/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class RevObject
extends ObjectId {
    static final int PARSED = 1;
    int flags;

    RevObject(AnyObjectId name) {
        super(name);
    }

    void parseHeaders(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.loadCanonical(walk);
        this.flags |= 1;
    }

    void parseBody(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if ((this.flags & 1) == 0) {
            this.parseHeaders(walk);
        }
    }

    final byte[] loadCanonical(RevWalk walk) throws IOException, MissingObjectException, IncorrectObjectTypeException, CorruptObjectException {
        return walk.reader.open(this, this.getType()).getCachedBytes();
    }

    public abstract int getType();

    public final ObjectId getId() {
        return this;
    }

    public final boolean equals(AnyObjectId o) {
        return this == o;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final boolean has(RevFlag flag) {
        return (this.flags & flag.mask) != 0;
    }

    public final boolean hasAny(RevFlagSet set) {
        return (this.flags & set.mask) != 0;
    }

    public final boolean hasAll(RevFlagSet set) {
        return (this.flags & set.mask) == set.mask;
    }

    public final void add(RevFlag flag) {
        this.flags |= flag.mask;
    }

    public final void add(RevFlagSet set) {
        this.flags |= set.mask;
    }

    public final void remove(RevFlag flag) {
        this.flags &= ~flag.mask;
    }

    public final void remove(RevFlagSet set) {
        this.flags &= ~set.mask;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(Constants.typeString(this.getType()));
        s.append(' ');
        s.append(this.name());
        s.append(' ');
        this.appendCoreFlags(s);
        return s.toString();
    }

    protected void appendCoreFlags(StringBuilder s) {
        s.append((this.flags & 0x20) != 0 ? (char)'o' : '-');
        s.append((this.flags & 0x10) != 0 ? (char)'t' : '-');
        s.append((this.flags & 8) != 0 ? (char)'r' : '-');
        s.append((this.flags & 4) != 0 ? (char)'u' : '-');
        s.append((this.flags & 2) != 0 ? (char)'s' : '-');
        s.append((this.flags & 1) != 0 ? (char)'p' : '-');
    }
}

