/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.RefDirectory;
import org.eclipse.jgit.storage.file.RefDirectoryUpdate;

class RefDirectoryRename
extends RefRename {
    private final RefDirectory refdb;
    private ObjectId objId;
    private boolean updateHEAD;
    private RefDirectoryUpdate tmp;

    RefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
        super(src, dst);
        this.refdb = src.getRefDatabase();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RefUpdate.Result doRename() throws IOException {
        if (this.source.getRef().isSymbolic()) {
            return RefUpdate.Result.IO_FAILURE;
        }
        this.objId = this.source.getOldObjectId();
        this.updateHEAD = this.needToUpdateHEAD();
        this.tmp = this.refdb.newTemporaryUpdate();
        rw = new RevWalk(this.refdb.getRepository());
        try {
            this.tmp.setNewObjectId(this.objId);
            this.tmp.setForceUpdate(true);
            this.tmp.disableRefLog();
            switch (RefDirectoryRename.$SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result()[this.tmp.update(rw).ordinal()]) {
                case 3: 
                case 4: 
                case 5: {
                    ** break;
                }
            }
            var4_2 = this.tmp.getResult();
        }
        catch (Throwable var3_10) {
            try {
                this.refdb.delete(this.tmp);
            }
            catch (IOException v0) {
                this.refdb.fileFor(this.tmp.getName()).delete();
            }
            rw.release();
            throw var3_10;
        }
        try {
            this.refdb.delete(this.tmp);
        }
        catch (IOException v1) {
            this.refdb.fileFor(this.tmp.getName()).delete();
        }
        rw.release();
        return var4_2;
lbl-1000:
        // 1 sources

        {
            if (this.renameLog(this.source, this.tmp)) ** GOTO lbl-1000
            var4_3 = RefUpdate.Result.IO_FAILURE;
        }
        try {
            this.refdb.delete(this.tmp);
        }
        catch (IOException v2) {
            this.refdb.fileFor(this.tmp.getName()).delete();
        }
        rw.release();
        return var4_3;
lbl-1000:
        // 1 sources

        {
            dst = this.destination;
            if (!this.updateHEAD) ** GOTO lbl60
            if (this.linkHEAD(this.destination)) ** GOTO lbl-1000
            this.renameLog(this.tmp, this.source);
            var4_4 = RefUpdate.Result.LOCK_FAILURE;
        }
        try {
            this.refdb.delete(this.tmp);
        }
        catch (IOException v3) {
            this.refdb.fileFor(this.tmp.getName()).delete();
        }
        rw.release();
        return var4_4;
lbl-1000:
        // 1 sources

        {
            dst = this.refdb.newUpdate("HEAD", false);
            dst.setRefLogIdent(this.destination.getRefLogIdent());
            dst.setRefLogMessage(this.destination.getRefLogMessage(), false);
lbl60:
            // 2 sources

            this.source.setExpectedOldObjectId(this.objId);
            this.source.setForceUpdate(true);
            this.source.disableRefLog();
            if (this.source.delete(rw) == RefUpdate.Result.FORCED) ** GOTO lbl-1000
            this.renameLog(this.tmp, this.source);
            if (this.updateHEAD) {
                this.linkHEAD(this.source);
            }
            var4_5 = this.source.getResult();
        }
        try {
            this.refdb.delete(this.tmp);
        }
        catch (IOException v4) {
            this.refdb.fileFor(this.tmp.getName()).delete();
        }
        rw.release();
        return var4_5;
lbl-1000:
        // 1 sources

        {
            if (this.renameLog(this.tmp, this.destination)) ** GOTO lbl-1000
            this.renameLog(this.tmp, this.source);
            this.source.setExpectedOldObjectId(ObjectId.zeroId());
            this.source.setNewObjectId(this.objId);
            this.source.update(rw);
            if (this.updateHEAD) {
                this.linkHEAD(this.source);
            }
            var4_6 = RefUpdate.Result.IO_FAILURE;
        }
        try {
            this.refdb.delete(this.tmp);
        }
        catch (IOException v5) {
            this.refdb.fileFor(this.tmp.getName()).delete();
        }
        rw.release();
        return var4_6;
lbl-1000:
        // 1 sources

        {
            dst.setExpectedOldObjectId(ObjectId.zeroId());
            dst.setNewObjectId(this.objId);
            if (dst.update(rw) == RefUpdate.Result.NEW) ** GOTO lbl-1000
            if (this.renameLog(this.destination, this.tmp)) {
                this.renameLog(this.tmp, this.source);
            }
            this.source.setExpectedOldObjectId(ObjectId.zeroId());
            this.source.setNewObjectId(this.objId);
            this.source.update(rw);
            if (this.updateHEAD) {
                this.linkHEAD(this.source);
            }
            var4_7 = dst.getResult();
        }
        try {
            this.refdb.delete(this.tmp);
        }
        catch (IOException v6) {
            this.refdb.fileFor(this.tmp.getName()).delete();
        }
        rw.release();
        return var4_7;
lbl-1000:
        // 1 sources

        {
            var4_8 = RefUpdate.Result.RENAMED;
        }
        try {
            this.refdb.delete(this.tmp);
        }
        catch (IOException v7) {
            this.refdb.fileFor(this.tmp.getName()).delete();
        }
        rw.release();
        return var4_8;
    }

    private boolean renameLog(RefUpdate src, RefUpdate dst) {
        File srcLog = this.refdb.logFor(src.getName());
        File dstLog = this.refdb.logFor(dst.getName());
        if (!srcLog.exists()) {
            return true;
        }
        if (!RefDirectoryRename.rename(srcLog, dstLog)) {
            return false;
        }
        try {
            int levels = RefDirectory.levelsIn(src.getName()) - 2;
            RefDirectory.delete(srcLog, levels);
            return true;
        }
        catch (IOException iOException) {
            RefDirectoryRename.rename(dstLog, srcLog);
            return false;
        }
    }

    private static boolean rename(File src, File dst) {
        if (src.renameTo(dst)) {
            return true;
        }
        File dir = dst.getParentFile();
        if (!(!dir.exists() && dir.mkdirs() || dir.isDirectory())) {
            return false;
        }
        return src.renameTo(dst);
    }

    private boolean linkHEAD(RefUpdate target) {
        try {
            RefDirectoryUpdate u = this.refdb.newUpdate("HEAD", false);
            u.disableRefLog();
            switch (u.link(target.getName())) {
                case NO_CHANGE: 
                case NEW: 
                case FORCED: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

