/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.storage.file.ByteArrayWindow;
import org.eclipse.jgit.storage.file.ByteWindow;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.LocalObjectToPack;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.WindowCache;
import org.eclipse.jgit.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.storage.pack.PackWriter;

final class WindowCursor
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    private ByteWindow window;
    final FileObjectDatabase db;

    WindowCursor(FileObjectDatabase db) {
        this.db = db;
    }

    public ObjectReader newReader() {
        return new WindowCursor(this.db);
    }

    public boolean has(AnyObjectId objectId) throws IOException {
        return this.db.has(objectId);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = this.db.openObject(this, objectId);
        if (ldr == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), "unknown");
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
        }
        return ldr;
    }

    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz = this.db.getObjectSize(this, objectId);
        if (sz < 0L) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), "unknown");
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        return sz;
    }

    public LocalObjectToPack newObjectToPack(RevObject obj) {
        return new LocalObjectToPack(obj);
    }

    public void selectObjectRepresentation(PackWriter packer, ObjectToPack otp) throws IOException, MissingObjectException {
        this.db.selectObjectRepresentation(packer, otp, this);
    }

    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp) throws IOException, StoredObjectRepresentationNotAvailableException {
        LocalObjectToPack src = (LocalObjectToPack)otp;
        src.pack.copyAsIs(out, src, this);
    }

    int copy(PackFile pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        long length = pack.length;
        int need = cnt;
        while (need > 0 && position < length) {
            this.pin(pack, position);
            int r = this.window.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
        }
        return cnt - need;
    }

    int inflate(PackFile pack, long position, byte[] dstbuf, int dstoff) throws IOException, DataFormatException {
        int n;
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.window.setInput(position, this.inf);
        do {
            if ((n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff)) != 0) continue;
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.window.setInput(position, this.inf);
                continue;
            }
            if (this.inf.finished()) {
                return dstoff;
            }
            throw new DataFormatException();
        } while ((dstoff += n) < dstbuf.length);
        return dstoff;
    }

    ByteArrayWindow quickCopy(PackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.window instanceof ByteArrayWindow && this.window.contains(p, pos + (cnt - 1L))) {
            return (ByteArrayWindow)this.window;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(PackFile pack, long position) throws IOException {
        ByteWindow w = this.window;
        if (w == null || !w.contains(pack, position)) {
            this.window = null;
            this.window = WindowCache.get(pack, position);
        }
    }

    int getStreamFileThreshold() {
        if (this.db == null) {
            return 0x100000;
        }
        return this.db.getStreamFileThreshold();
    }

    public void release() {
        this.window = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }
}

