/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;

public class IO {
    public static final byte[] readFully(File path) throws FileNotFoundException, IOException {
        return IO.readFully(path, Integer.MAX_VALUE);
    }

    public static final byte[] readFully(File path, int max) throws FileNotFoundException, IOException {
        byte[] byArray;
        FileInputStream in = new FileInputStream(path);
        try {
            long sz = in.getChannel().size();
            if (sz > (long)max) {
                throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path));
            }
            byte[] buf = new byte[(int)sz];
            IO.readFully(in, buf, 0, buf.length);
            byArray = buf;
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static void readFully(InputStream fd, byte[] dst, int off, int len) throws IOException {
        while (len > 0) {
            int r = fd.read(dst, off, len);
            if (r <= 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            off += r;
            len -= r;
        }
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }

    private IO() {
    }
}

