/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;

public final class StringUtils {
    private static final char[] LC = new char[91];

    static {
        int c = 0;
        while (c < LC.length) {
            StringUtils.LC[c] = c;
            c = (char)(c + 1);
        }
        c = 65;
        while (c <= 90) {
            StringUtils.LC[c] = (char)(97 + (c - 65));
            c = (char)(c + 1);
        }
    }

    public static char toLowerCase(char c) {
        return c <= 'Z' ? LC[c] : c;
    }

    public static String toLowerCase(String in) {
        StringBuilder r = new StringBuilder(in.length());
        int i = 0;
        while (i < in.length()) {
            r.append(StringUtils.toLowerCase(in.charAt(i)));
            ++i;
        }
        return r.toString();
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int i = 0;
        while (i < a.length()) {
            if (StringUtils.toLowerCase(a.charAt(i)) != StringUtils.toLowerCase(b.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean toBoolean(String stringValue) {
        if (stringValue == null) {
            throw new NullPointerException(JGitText.get().expectedBooleanStringValue);
        }
        if (StringUtils.equalsIgnoreCase("yes", stringValue) || StringUtils.equalsIgnoreCase("true", stringValue) || StringUtils.equalsIgnoreCase("1", stringValue) || StringUtils.equalsIgnoreCase("on", stringValue)) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase("no", stringValue) || StringUtils.equalsIgnoreCase("false", stringValue) || StringUtils.equalsIgnoreCase("0", stringValue) || StringUtils.equalsIgnoreCase("off", stringValue)) {
            return false;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().notABoolean, stringValue));
    }

    private StringUtils() {
    }
}

