/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogListItem
extends ControlListItem<CatalogDescriptor> {
    private Label nameLabel;
    private Label descriptionLabel;

    public CatalogListItem(Composite parent, int style, DiscoveryResources resources, ImageRegistry imageRegistry, CatalogDescriptor element) {
        super(parent, style, (Object)element);
        this.createContent(resources, imageRegistry);
    }

    private void createContent(DiscoveryResources resources, ImageRegistry imageRegistry) {
        CatalogDescriptor catalogDescriptor = (CatalogDescriptor)this.getData();
        CatalogListItem parent = this;
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).equalWidth(false).applyTo((Composite)parent);
        Label iconLabel = new Label((Composite)parent, 0);
        if (catalogDescriptor.getIcon() != null) {
            String iconKey = String.valueOf(catalogDescriptor.getUrl().toString()) + "#icon";
            imageRegistry.put(iconKey, catalogDescriptor.getIcon());
            iconLabel.setImage(imageRegistry.get(iconKey));
        }
        iconLabel.setBackground(null);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)iconLabel);
        this.registerChild((Control)iconLabel);
        this.nameLabel = new Label((Composite)parent, 0);
        this.nameLabel.setFont(resources.getHeaderFont());
        this.nameLabel.setText(catalogDescriptor.getLabel());
        this.nameLabel.setBackground(null);
        this.registerChild((Control)this.nameLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameLabel);
        if (catalogDescriptor.getDescription() != null) {
            this.descriptionLabel = new Label((Composite)parent, 64);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)this.descriptionLabel);
            this.descriptionLabel.setBackground(null);
            this.descriptionLabel.setText(catalogDescriptor.getDescription());
            this.registerChild((Control)this.descriptionLabel);
        }
    }

    protected void refresh() {
    }
}

