/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AutomationConfiguration;
import com.sshtools.common.automate.RemoteIdentification;
import com.sshtools.common.automate.RemoteIdentificationException;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.util.Map;

public class RemoteIdentificationFactory {
    private static Map remoteIdentifications = null;

    static {
        try {
            if (ConfigurationLoader.isConfigurationAvailable(AutomationConfiguration.class)) {
                remoteIdentifications = ((AutomationConfiguration)ConfigurationLoader.getConfiguration(AutomationConfiguration.class)).getRemoteIdentifications();
            }
        }
        catch (ConfigurationException configurationException) {}
    }

    public static synchronized RemoteIdentification getInstance(String serverId, String hostname) throws RemoteIdentificationException {
        RemoteIdentification rid;
        if (remoteIdentifications == null) {
            throw new RemoteIdentificationException("There are no remote identification rules!");
        }
        for (Map.Entry entry : remoteIdentifications.entrySet()) {
            rid = (RemoteIdentification)entry.getValue();
            if (hostname == null || !rid.getDefaultName().equals(hostname)) continue;
            return rid;
        }
        for (Map.Entry entry : remoteIdentifications.entrySet()) {
            rid = (RemoteIdentification)entry.getValue();
            if (!rid.testRules(serverId)) continue;
            return rid;
        }
        throw new RemoteIdentificationException("Failed to find a remote identification rule");
    }

    public static void main(String[] args) {
        try {
            String serverId = "http://www.sshtools.com J2SSH 0.1.1 beta [CLIENT]";
            RemoteIdentification rid = RemoteIdentificationFactory.getInstance(serverId, null);
            System.out.println("Remote Identification: " + rid.getName(serverId));
            serverId = "OpenSSH_3.4p1";
            rid = RemoteIdentificationFactory.getInstance(serverId, null);
            System.out.println("Remote Identification: " + rid.getName(serverId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

