/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostsTab
extends JPanel
implements OptionsTab,
ActionListener {
    public static final String GLOBAL_ICON = "/com/sshtools/common/ui/largeserveridentity.png";
    public static final String ALLOW_ICON = "/com/sshtools/common/ui/ok.png";
    public static final String DENY_ICON = "/com/sshtools/common/ui/cancel.png";
    public static final String REMOVE_ICON = "/com/sshtools/common/ui/remove.png";
    private static Log log = LogFactory.getLog(HostsTab.class);
    private JList hosts;
    private AbstractKnownHostsKeyVerification hostKeyVerifier;
    private JButton remove;
    private HostsListModel model;

    public HostsTab(AbstractKnownHostsKeyVerification hostKeyVerifier) {
        this.hostKeyVerifier = hostKeyVerifier;
        this.model = new HostsListModel();
        this.hosts = new JList(this.model);
        this.hosts.setVisibleRowCount(10);
        this.hosts.setCellRenderer(new HostRenderer());
        this.hosts.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                HostsTab.this.setAvailableActions();
            }
        });
        this.remove = new JButton("Remove", new ResourceIcon(REMOVE_ICON));
        this.remove.addActionListener(this);
        JPanel b = new JPanel(new GridBagLayout());
        b.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 4, 0);
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(b, this.remove, gbc, 0);
        gbc.weighty = 1.0;
        JPanel s = new JPanel(new BorderLayout());
        s.add((Component)new JScrollPane(this.hosts), "Center");
        s.add((Component)b, "East");
        IconWrapperPanel w = new IconWrapperPanel(new ResourceIcon(GLOBAL_ICON), s);
        this.setLayout(new BorderLayout());
        this.add((Component)w, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.reset();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.remove) {
            this.model.removeHostAt(this.hosts.getSelectedIndex());
        }
        this.setAvailableActions();
    }

    private void setAvailableActions() {
        HostWrapper w = this.model.getSize() > 0 && this.hosts.getSelectedValues().length == 1 ? this.model.getHostAt(this.hosts.getSelectedIndex()) : null;
        this.remove.setEnabled(w != null);
    }

    public void reset() {
        ((HostsListModel)this.hosts.getModel()).refresh();
        this.setAvailableActions();
    }

    public String getTabContext() {
        return "Options";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Hosts";
    }

    public String getTabToolTipText() {
        return "Allowed and denied hosts.";
    }

    public int getTabMnemonic() {
        return 104;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        try {
            Map map = this.hostKeyVerifier.allowedHosts();
            String[] hosts = new String[map.keySet().size()];
            map.keySet().toArray(hosts);
            log.debug((Object)"Checking if any allowed hosts need to be removed");
            int i = hosts.length - 1;
            while (i >= 0) {
                HostWrapper w;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Looking for host " + hosts[i]));
                }
                if ((w = this.model.getHost(hosts[i])) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found host " + hosts[i]));
                    }
                    if (!w.allow) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Denying host " + hosts[i]));
                        }
                        this.hostKeyVerifier.removeAllowedHost(hosts[i]);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Host removed " + hosts[i]));
                    }
                    this.hostKeyVerifier.removeAllowedHost(hosts[i]);
                }
                --i;
            }
            this.hostKeyVerifier.saveHostFile();
        }
        catch (InvalidHostFileException ihfe) {
            log.error((Object)"Failed to store hosts file.", (Throwable)ihfe);
        }
    }

    public void tabSelected() {
    }

    class HostRenderer
    extends DefaultListCellRenderer {
        Icon allowIcon = new ResourceIcon("/com/sshtools/common/ui/ok.png");
        Icon denyIcon = new ResourceIcon("/com/sshtools/common/ui/cancel.png");

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            HostWrapper w = (HostWrapper)value;
            this.setIcon(w.allow ? this.allowIcon : this.denyIcon);
            this.setText(w.host);
            return this;
        }
    }

    class HostWrapper {
        boolean allow;
        String host;
        SshPublicKey key;
        Map keys;

        HostWrapper(boolean allow, String host, Map keys) {
            this.allow = allow;
            this.host = host;
            this.keys = keys;
        }
    }

    class HostsListModel
    extends AbstractListModel {
        List hosts = new ArrayList();

        public HostsListModel() {
            this.refresh();
        }

        public void refresh() {
            this.hosts.clear();
            Map map = HostsTab.this.hostKeyVerifier.allowedHosts();
            for (String k : map.keySet()) {
                Map keys = (Map)map.get(k);
                this.hosts.add(new HostWrapper(true, k, keys));
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public HostWrapper getHost(String name) {
            for (HostWrapper w : this.hosts) {
                if (!w.host.equals(name)) continue;
                return w;
            }
            return null;
        }

        public int getSize() {
            return this.hosts.size();
        }

        public Object getElementAt(int index) {
            return this.hosts.get(index);
        }

        public HostWrapper getHostAt(int index) {
            return (HostWrapper)this.hosts.get(index);
        }

        public void removeHostAt(int index) {
            this.hosts.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }

        public void updateHostAt(int index) {
            this.fireContentsChanged(this, index, index);
        }
    }
}

