/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.XTextField;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericTextField
extends XTextField {
    private Color positiveBackground;
    private DecimalFormatSymbols symbols;
    private NumberFormat numberFormat;
    private boolean selectAllOnFocusGain;
    private int wColumnWidth;

    public NumericTextField(Number min, Number max) {
        this(min, max, min);
    }

    public NumericTextField(Number min, Number max, Number initial, boolean rightJustify) {
        this(min, max, initial, rightJustify, null);
    }

    public NumericTextField(Number min, Number max, Number initial) {
        this(min, max, initial, true);
    }

    public NumericTextField(Number min, Number max, Number initial, boolean rightJustify, NumberFormat numberFormat) {
        super(Math.max(min.toString().length(), max.toString().length()));
        this.setNumberFormat(numberFormat);
        if (!min.getClass().equals(max.getClass()) || !max.getClass().equals(initial.getClass())) {
            throw new IllegalArgumentException("All arguments must be of the same class");
        }
        this.setDocument(new ADocument(min, max));
        this.setValue(initial);
        this.setRightJustify(rightJustify);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (!e.isTemporary()) {
            switch (e.getID()) {
                case 1005: {
                    if (this.getNumberFormat() == null) break;
                    String s = this.getNumberFormat().format(this.getValue()).toString();
                    if (this.getText().equals(s)) break;
                    this.setText(s);
                    break;
                }
                case 1004: {
                    if (!this.isSelectAllOnFocusGain()) break;
                    this.selectAll();
                }
            }
        }
    }

    public boolean isSelectAllOnFocusGain() {
        return this.selectAllOnFocusGain;
    }

    public void setSelectAllOnFocusGain(boolean selectAllOnFocusGain) {
        this.selectAllOnFocusGain = selectAllOnFocusGain;
    }

    public void setMaximum(Number max) {
        ((ADocument)this.getDocument()).setMaximum(max);
    }

    public Number getMaximum() {
        return ((ADocument)this.getDocument()).max;
    }

    public void setMinimum(Number min) {
        ((ADocument)this.getDocument()).setMinimum(min);
    }

    public Number getMinimum() {
        return ((ADocument)this.getDocument()).min;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.symbols = numberFormat instanceof DecimalFormat ? ((DecimalFormat)numberFormat).getDecimalFormatSymbols() : new DecimalFormatSymbols();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setRightJustify(boolean rightJustify) {
        this.setHorizontalAlignment(rightJustify ? 4 : 2);
    }

    public boolean isRightJustify() {
        return this.getHorizontalAlignment() == 4;
    }

    public void setText(String s) {
        ADocument doc = (ADocument)this.getDocument();
        Number oldValue = doc.currentVal;
        try {
            doc.currentVal = doc.parse(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (oldValue != doc.currentVal) {
            doc.checkingEnabled = false;
            super.setText(s);
            doc.checkingEnabled = true;
        }
    }

    public void setValue(Number i) {
        this.setText(i.toString());
    }

    public Number getValue() {
        return ((ADocument)this.getDocument()).getValue();
    }

    class ADocument
    extends PlainDocument {
        Number currentVal;
        Number max;
        Number min;
        boolean checkingEnabled = true;
        boolean rightJustify = true;

        public ADocument(Number min, Number max) {
            this.min = min;
            this.max = max;
            this.currentVal = min.getClass().equals(Byte.class) ? (Number)new Byte(0) : (Number)(min.getClass().equals(Short.class) ? (Number)new Short(0) : (Number)(min.getClass().equals(Integer.class) ? (Number)new Integer(0) : (Number)(min.getClass().equals(Long.class) ? (Number)new Long(0L) : (Number)(min.getClass().equals(Float.class) ? (Number)new Float(0.0f) : (Number)new Double(0.0)))));
        }

        public void setMaximum(Number max) {
            this.max = max;
        }

        public void setMinimum(Number min) {
            this.min = min;
        }

        public void setRightJustify(boolean rightJustify) {
            this.rightJustify = rightJustify;
        }

        public boolean isRightJustify() {
            return this.rightJustify;
        }

        public Number getValue() {
            return this.currentVal;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (!this.checkingEnabled) {
                super.insertString(offs, str, a);
                return;
            }
            String proposedResult = null;
            if (this.getLength() == 0) {
                proposedResult = str;
            } else {
                StringBuffer currentBuffer = new StringBuffer(this.getText(0, this.getLength()));
                currentBuffer.insert(offs, str);
                proposedResult = currentBuffer.toString();
            }
            try {
                this.currentVal = this.parse(proposedResult);
                super.insertString(offs, str, a);
            }
            catch (Exception exception) {}
        }

        public Number parse(String proposedResult) throws NumberFormatException {
            Double d = new Double(0.0);
            if (!proposedResult.equals(String.valueOf(NumericTextField.this.symbols.getMinusSign())) && proposedResult.length() != 0) {
                if (NumericTextField.this.getNumberFormat() != null) {
                    StringBuffer sB = new StringBuffer();
                    int i = 0;
                    while (i < proposedResult.length()) {
                        char ch = proposedResult.charAt(i);
                        if (ch == NumericTextField.this.symbols.getDecimalSeparator() || ch >= '0' && ch <= '9') {
                            sB.append(ch);
                        }
                        ++i;
                    }
                    String s = sB.toString();
                    int i2 = 0;
                    while (i2 < s.length() && s.charAt(i2) != NumericTextField.this.symbols.getDecimalSeparator()) {
                        ++i2;
                    }
                    int before = i2;
                    int after = 0;
                    if (before < s.length()) {
                        after = s.length() - i2 - 1;
                    }
                    if (before > NumericTextField.this.getNumberFormat().getMaximumIntegerDigits()) {
                        throw new NumberFormatException("More digits BEFORE the decimal separator than allowed:" + proposedResult);
                    }
                    if (after > NumericTextField.this.getNumberFormat().getMaximumFractionDigits()) {
                        throw new NumberFormatException("More digits AFTER the decimal separator than allowed:" + proposedResult);
                    }
                    try {
                        d = new Double(NumericTextField.this.getNumberFormat().parse(proposedResult).doubleValue());
                    }
                    catch (ParseException pE) {
                        throw new NumberFormatException("Failed to parse. " + proposedResult + pE.getMessage());
                    }
                } else {
                    d = new Double(proposedResult);
                }
            }
            if (d >= this.min.doubleValue() && d <= this.max.doubleValue()) {
                if (this.min.getClass().equals(Byte.class)) {
                    return new Byte(d.byteValue());
                }
                if (this.min.getClass().equals(Short.class)) {
                    return new Short(d.shortValue());
                }
                if (this.min.getClass().equals(Integer.class)) {
                    return new Integer(d.intValue());
                }
                if (this.min.getClass().equals(Long.class)) {
                    return new Long(d.longValue());
                }
                if (this.min.getClass().equals(Float.class)) {
                    return new Float(d.floatValue());
                }
                return d;
            }
            throw new NumberFormatException(d + " Is out of range. Minimum is " + this.min.doubleValue() + ", Maximum is " + this.max.doubleValue());
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (!this.checkingEnabled) {
                super.remove(offs, len);
                return;
            }
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(len + offs, currentText.length());
            String proposedResult = String.valueOf(beforeOffset) + afterOffset;
            try {
                this.currentVal = this.parse(proposedResult);
                super.remove(offs, len);
            }
            catch (Exception exception) {}
        }
    }
}

