/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsConnectionHostTab
extends JPanel
implements SshToolsConnectionTab {
    public static final int DEFAULT_PORT = 22;
    public static final String CONNECT_ICON = "largeserveridentity.png";
    public static final String AUTH_ICON = "largelock.png";
    public static final String SHOW_AVAILABLE = "<Show available methods>";
    protected XTextField jTextHostname = new XTextField();
    protected NumericTextField jTextPort = new NumericTextField(new Integer(0), new Integer(65535), new Integer(22));
    protected XTextField jTextUsername = new XTextField();
    protected JList jListAuths = new JList();
    protected List methods = new ArrayList();
    protected SshToolsConnectionProfile profile;
    protected JCheckBox allowAgentForwarding;
    protected Log log = LogFactory.getLog(SshToolsConnectionHostTab.class);

    public SshToolsConnectionHostTab() {
        JPanel mainConnectionDetailsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Hostname"), gbc, 0);
        gbc.fill = 2;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextHostname, gbc, 0);
        gbc.fill = 0;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Port"), gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextPort, gbc, 0);
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, new JLabel("Username"), gbc, 0);
        gbc.fill = 2;
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(mainConnectionDetailsPanel, this.jTextUsername, gbc, 0);
        gbc.fill = 0;
        IconWrapperPanel iconMainConnectionDetailsPanel = new IconWrapperPanel(new ResourceIcon(SshToolsConnectionHostTab.class, CONNECT_ICON), mainConnectionDetailsPanel);
        JPanel authMethodsPanel = new JPanel(new GridBagLayout());
        authMethodsPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(authMethodsPanel, new JLabel("Authentication Methods"), gbc, 0);
        gbc.fill = 2;
        gbc.weighty = 1.0;
        this.jListAuths.setVisibleRowCount(5);
        UIUtil.jGridBagAdd(authMethodsPanel, new JScrollPane(this.jListAuths), gbc, 0);
        this.allowAgentForwarding = new JCheckBox("Allow agent forwarding");
        UIUtil.jGridBagAdd(authMethodsPanel, this.allowAgentForwarding, gbc, 0);
        IconWrapperPanel iconAuthMethodsPanel = new IconWrapperPanel(new ResourceIcon(SshToolsConnectionHostTab.class, AUTH_ICON), authMethodsPanel);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(this, iconMainConnectionDetailsPanel, gbc, 0);
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(this, iconAuthMethodsPanel, gbc, 0);
        this.addAuthenticationMethods();
    }

    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        this.jTextHostname.setText(profile == null ? "" : profile.getHost());
        this.jTextUsername.setText(profile == null ? "" : profile.getUsername());
        this.jTextPort.setValue(new Integer(profile == null ? 22 : profile.getPort()));
        if (System.getProperty("sshtools.agent") == null) {
            this.allowAgentForwarding.setSelected(false);
            this.allowAgentForwarding.setEnabled(false);
        } else {
            this.allowAgentForwarding.setEnabled(true);
            this.allowAgentForwarding.setSelected(profile != null && profile.getAllowAgentForwarding());
        }
        Map auths = profile == null ? new HashMap() : profile.getAuthenticationMethods();
        Iterator it = auths.entrySet().iterator();
        int[] selectionarray = new int[auths.values().size()];
        int count = 0;
        ListModel model = this.jListAuths.getModel();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String authmethod = (String)entry.getKey();
            int i = 0;
            while (i < model.getSize()) {
                if (model.getElementAt(i).equals(authmethod)) {
                    selectionarray[count++] = i;
                    break;
                }
                ++i;
            }
            this.jListAuths.clearSelection();
            this.jListAuths.setSelectedIndices(selectionarray);
        }
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    private void addAuthenticationMethods() {
        ArrayList<String> methods = new ArrayList<String>();
        methods.add(SHOW_AVAILABLE);
        methods.addAll(SshAuthenticationClientFactory.getSupportedMethods());
        this.jListAuths.setListData(methods.toArray());
        this.jListAuths.setSelectedIndex(0);
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Host";
    }

    public String getTabToolTipText() {
        return "The main host connection details.";
    }

    public int getTabMnemonic() {
        return 104;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        if (this.jTextHostname.getText().equals("") || this.jTextPort.getText().equals("") || this.jTextUsername.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter all details!", "Connect", 0);
            return false;
        }
        List chosen = this.getChosenAuth();
        if (chosen != null) {
            for (String method : chosen) {
                try {
                    SshAuthenticationClientFactory.newInstance(method);
                }
                catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
                    JOptionPane.showMessageDialog(this, String.valueOf(method) + " is not supported!");
                    return false;
                }
            }
        }
        return true;
    }

    private List getChosenAuth() {
        Object[] auths = this.jListAuths.getSelectedValues();
        ArrayList<String> l = new ArrayList<String>();
        if (auths != null) {
            int i = 0;
            while (i < auths.length) {
                String a = (String)auths[i];
                if (a.equals(SHOW_AVAILABLE)) {
                    return null;
                }
                l.add(a);
                ++i;
            }
        } else {
            return null;
        }
        return l;
    }

    public void applyTab() {
        this.profile.setHost(this.jTextHostname.getText());
        this.profile.setPort(Integer.valueOf(this.jTextPort.getText()));
        this.profile.setUsername(this.jTextUsername.getText());
        this.profile.setAllowAgentForwarding(this.allowAgentForwarding.getModel().isSelected());
        List chosen = this.getChosenAuth();
        this.profile.removeAuthenticationMethods();
        if (chosen != null) {
            for (String method : chosen) {
                try {
                    SshAuthenticationClient auth = SshAuthenticationClientFactory.newInstance(method);
                    auth.setUsername(this.jTextUsername.getText());
                    this.profile.addAuthenticationMethod(auth);
                }
                catch (AlgorithmNotSupportedException anse) {
                    this.log.error((Object)"This should have been caught by validateTab()?", (Throwable)anse);
                }
            }
        }
    }

    public void tabSelected() {
    }
}

