/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.configuration;

import com.sshtools.daemon.vfs.VFSMount;
import com.sshtools.daemon.vfs.VFSPermission;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlatformConfiguration
extends DefaultHandler {
    private static Log log = LogFactory.getLog(PlatformConfiguration.class);
    private static final String PLATFORM_ELEMENT = "PlatformConfiguration";
    private static final String NATIVE_PROCESS_ELEMENT = "NativeProcessProvider";
    private static final String NATIVE_AUTH_ELEMENT = "NativeAuthenticationProvider";
    private static final String NFS_ELEMENT = "NativeFileSystemProvider";
    private static final String NATIVE_SETTING_ELEMENT = "NativeSetting";
    private static final String VFSMOUNT_ELEMENT = "VFSMount";
    private static final String VFSROOT_ELEMENT = "VFSRoot";
    private static final String VFSPERMISSION_ELEMENT = "VFSPermission";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String MOUNT_ATTRIBUTE = "mount";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String PERMISSIONS_ATTRIBUTE = "permissions";
    private String currentElement = null;
    private Map nativeSettings = new HashMap();
    private String nativeProcessProvider = null;
    private String nativeAuthenticationProvider = null;
    private String nativeFileSystemProvider = null;
    private Map vfsMounts = new HashMap();
    private VFSMount vfsRoot = null;

    protected PlatformConfiguration(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this.reload(in);
    }

    public void reload(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)new PlatformConfigurationSAXHandler());
    }

    public Map getVFSMounts() {
        return this.vfsMounts;
    }

    public String getNativeAuthenticationProvider() {
        return this.nativeAuthenticationProvider;
    }

    public String getNativeFileSystemProvider() {
        return this.nativeFileSystemProvider;
    }

    public String getNativeProcessProvider() {
        return this.nativeProcessProvider;
    }

    public String getSetting(String name) {
        return (String)this.nativeSettings.get(name);
    }

    public String getSetting(String name, String defaultValue) {
        if (this.nativeSettings.containsKey(name)) {
            return (String)this.nativeSettings.get(name);
        }
        return defaultValue;
    }

    public boolean containsSetting(String name) {
        return this.nativeSettings.containsKey(name);
    }

    public VFSMount getVFSRoot() {
        return this.vfsRoot;
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = String.valueOf(xml) + "<!-- Platform Configuration file, Determines the behaviour of platform specific services -->\n<PlatformConfiguration>\n";
        xml = String.valueOf(xml) + "   <!-- The process provider for executing and redirecting a process -->\n";
        xml = String.valueOf(xml) + "   <NativeProcessProvider>" + this.nativeProcessProvider + "</" + NATIVE_PROCESS_ELEMENT + ">\n";
        xml = String.valueOf(xml) + "   <!-- The authentication provider for authenticating users and obtaining user information -->\n";
        xml = String.valueOf(xml) + "   <NativeAuthenticationProvider>" + this.nativeAuthenticationProvider + "</" + NATIVE_AUTH_ELEMENT + ">\n";
        xml = String.valueOf(xml) + "   <!-- Native settings which may be used by the process or authentication provider -->\n";
        for (Map.Entry entry : this.nativeSettings.entrySet()) {
            xml = String.valueOf(xml) + "   <NativeSetting name=\"" + entry.getKey().toString() + "\" " + VALUE_ATTRIBUTE + "=\"" + entry.getValue().toString() + "\"/>\n";
        }
        if (this.vfsRoot != null) {
            xml = String.valueOf(xml) + "   <VFSRoot path=\"" + this.vfsRoot + "\"/>\n";
        }
        for (Map.Entry entry : this.vfsMounts.entrySet()) {
            String path = (String)entry.getValue();
            String mount = (String)entry.getKey();
            xml = String.valueOf(xml) + "   <VFSMount " + (mount.equals(path) ? "" : "mount=\"" + entry.getKey().toString() + "\" ") + PATH_ATTRIBUTE + "=\"" + entry.getValue().toString() + "\"/>\n";
        }
        xml = String.valueOf(xml) + "</PlatformConfiguration>";
        return xml;
    }

    class PlatformConfigurationSAXHandler
    extends DefaultHandler {
        private VFSMount currentMount = null;

        PlatformConfigurationSAXHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
            String path;
            String permissions;
            String name;
            if (PlatformConfiguration.this.currentElement == null) {
                if (qname.equals(PlatformConfiguration.PLATFORM_ELEMENT)) {
                    PlatformConfiguration.this.currentElement = qname;
                }
                PlatformConfiguration.this.nativeProcessProvider = null;
                PlatformConfiguration.this.nativeAuthenticationProvider = null;
                PlatformConfiguration.this.nativeSettings.clear();
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.PLATFORM_ELEMENT)) {
                if (!(qname.equals(PlatformConfiguration.NATIVE_PROCESS_ELEMENT) || qname.equals(PlatformConfiguration.NATIVE_AUTH_ELEMENT) || qname.equals(PlatformConfiguration.NATIVE_SETTING_ELEMENT) || qname.equals(PlatformConfiguration.VFSMOUNT_ELEMENT) || qname.equals(PlatformConfiguration.VFSROOT_ELEMENT) || qname.equals(PlatformConfiguration.NFS_ELEMENT))) {
                    throw new SAXException("Unexpected element " + qname);
                }
            } else {
                if (!PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSMOUNT_ELEMENT)) throw new SAXException("Unexpected element " + qname);
                if (!qname.equals(PlatformConfiguration.VFSPERMISSION_ELEMENT)) {
                    throw new SAXException("Unexpected element " + qname);
                }
            }
            PlatformConfiguration.this.currentElement = qname;
            if (qname.equals(PlatformConfiguration.NATIVE_SETTING_ELEMENT)) {
                name = attrs.getValue(PlatformConfiguration.NAME_ATTRIBUTE);
                String value = attrs.getValue(PlatformConfiguration.VALUE_ATTRIBUTE);
                if (name == null || value == null) {
                    throw new SAXException("Required attributes missing for NativeSetting element");
                }
                log.debug((Object)("NativeSetting " + name + "=" + value));
                PlatformConfiguration.this.nativeSettings.put(name, value);
            }
            if (qname.equals(PlatformConfiguration.VFSPERMISSION_ELEMENT)) {
                name = attrs.getValue(PlatformConfiguration.NAME_ATTRIBUTE);
                permissions = attrs.getValue(PlatformConfiguration.PERMISSIONS_ATTRIBUTE);
                this.currentMount.setPermissions(new VFSPermission(name, permissions));
            }
            if (qname.equals(PlatformConfiguration.VFSMOUNT_ELEMENT)) {
                path = attrs.getValue(PlatformConfiguration.PATH_ATTRIBUTE);
                String mount = attrs.getValue(PlatformConfiguration.MOUNT_ATTRIBUTE);
                String permissions2 = attrs.getValue(PlatformConfiguration.PERMISSIONS_ATTRIBUTE);
                if (path == null || mount == null) throw new SAXException("Required path attribute for element <VFSMount> is missing");
                if (mount.trim().equals("/")) throw new SAXException("The root mount / cannot be configured, use <VFSRoot path=\"" + path + "\"/> instead");
                try {
                    this.currentMount = new VFSMount(mount, path);
                    if (permissions2 == null) {
                        this.currentMount.setPermissions(new VFSPermission("default"));
                    } else {
                        this.currentMount.setPermissions(new VFSPermission("default", permissions2));
                    }
                    if (PlatformConfiguration.this.vfsMounts.containsKey(this.currentMount.getMount())) {
                        throw new SAXException("The mount " + mount + " is already defined");
                    }
                    PlatformConfiguration.this.vfsMounts.put(this.currentMount.getMount(), this.currentMount);
                }
                catch (IOException iOException) {
                    throw new SAXException("VFSMount element is invalid mount=" + mount + " path=" + path);
                }
            }
            if (!qname.equals(PlatformConfiguration.VFSROOT_ELEMENT)) return;
            if (PlatformConfiguration.this.vfsRoot != null) {
                throw new SAXException("Only one VFSRoot can be defined");
            }
            path = attrs.getValue(PlatformConfiguration.PATH_ATTRIBUTE);
            permissions = attrs.getValue(PlatformConfiguration.PERMISSIONS_ATTRIBUTE);
            try {
                PlatformConfiguration.this.vfsRoot = new VFSMount("/", path);
                if (permissions != null) {
                    PlatformConfiguration.this.vfsRoot.setPermissions(new VFSPermission("default", permissions));
                } else {
                    PlatformConfiguration.this.vfsRoot.setPermissions(new VFSPermission("default"));
                }
                PlatformConfiguration.this.vfsRoot.setRoot(true);
                return;
            }
            catch (IOException iOException) {
                throw new SAXException("VFSRoot element is invalid path=" + path);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (PlatformConfiguration.this.currentElement == null) {
                throw new SAXException("Unexpected characters found");
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_AUTH_ELEMENT)) {
                PlatformConfiguration.this.nativeAuthenticationProvider = new String(ch, start, length).trim();
                log.debug((Object)("NativeAuthenticationProvider=" + PlatformConfiguration.this.nativeAuthenticationProvider));
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_PROCESS_ELEMENT)) {
                PlatformConfiguration.this.nativeProcessProvider = new String(ch, start, length).trim();
                log.debug((Object)("NativeProcessProvider=" + PlatformConfiguration.this.nativeProcessProvider));
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NFS_ELEMENT)) {
                PlatformConfiguration.this.nativeFileSystemProvider = new String(ch, start, length).trim();
                log.debug((Object)("NativeFileSystemProvider=" + PlatformConfiguration.this.nativeFileSystemProvider));
                return;
            }
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            if (PlatformConfiguration.this.currentElement == null) {
                throw new SAXException("Unexpected end element for " + qname);
            }
            if (!PlatformConfiguration.this.currentElement.equals(qname)) {
                throw new SAXException("Unexpected end element found");
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.PLATFORM_ELEMENT)) {
                PlatformConfiguration.this.currentElement = null;
                return;
            }
            if (PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSPERMISSION_ELEMENT)) {
                PlatformConfiguration.this.currentElement = PlatformConfiguration.VFSMOUNT_ELEMENT;
            } else {
                if (!(PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_SETTING_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_AUTH_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NATIVE_PROCESS_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.NFS_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSMOUNT_ELEMENT) || PlatformConfiguration.this.currentElement.equals(PlatformConfiguration.VFSROOT_ELEMENT))) {
                    throw new SAXException("Unexpected end element for " + qname);
                }
                PlatformConfiguration.this.currentElement = PlatformConfiguration.PLATFORM_ELEMENT;
            }
        }
    }
}

