/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.AgentSocketChannel;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentForwardingListener {
    private static Log log = LogFactory.getLog(SshAgentForwardingListener.class);
    private static HashMap agents = new HashMap();
    ServerSocket server;
    int port;
    String location;
    StartStopState state = new StartStopState(2);
    Thread thread;
    ConnectionProtocol connection;
    Vector references = new Vector();
    String sessionId;

    SshAgentForwardingListener(String sessionId, ConnectionProtocol connection) {
        log.info((Object)"Forwarding agent started");
        this.sessionId = sessionId;
        this.connection = connection;
        this.port = this.selectPort();
        this.location = "localhost:" + String.valueOf(this.port);
        this.thread = new Thread(new Runnable(){

            public void run() {
                block3: {
                    SshAgentForwardingListener.this.state.setValue(1);
                    try {
                        Socket socket;
                        SshAgentForwardingListener.this.server = new ServerSocket(SshAgentForwardingListener.this.port, 5, InetAddress.getByName("localhost"));
                        while (SshAgentForwardingListener.this.state.getValue() == 1 && (socket = SshAgentForwardingListener.this.server.accept()) != null) {
                            AgentSocketChannel channel = new AgentSocketChannel(true);
                            channel.bindSocket(socket);
                            if (SshAgentForwardingListener.this.connection.openChannel(channel)) continue;
                            log.warn((Object)"Failed to open agent forwarding channel");
                        }
                    }
                    catch (Exception e) {
                        if (SshAgentForwardingListener.this.state.getValue() != 1) break block3;
                        log.warn((Object)"Forwarding agent socket failed", (Throwable)e);
                    }
                }
                SshAgentForwardingListener.this.state.setValue(2);
            }
        });
    }

    public String getConfiguration() {
        return this.location;
    }

    public void addReference(Object obj) {
        if (!this.references.contains(obj)) {
            this.references.add(obj);
        }
    }

    public void removeReference(Object obj) {
        if (this.references.contains(obj)) {
            this.references.remove(obj);
            if (this.references.size() == 0) {
                this.stop();
                agents.remove(this.sessionId);
            }
        }
    }

    public void start() throws IOException {
        this.thread.start();
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        try {
            this.state.setValue(2);
            this.server.close();
        }
        catch (IOException iOException) {}
    }

    private int selectPort() {
        return 49152 + Math.round(16383.0f * ConfigurationLoader.getRND().nextFloat());
    }

    public static SshAgentForwardingListener getInstance(String sessionId, ConnectionProtocol connection) throws AgentNotAvailableException {
        if (agents.containsKey(sessionId)) {
            SshAgentForwardingListener agent = (SshAgentForwardingListener)agents.get(sessionId);
            return agent;
        }
        try {
            SshAgentForwardingListener agent = new SshAgentForwardingListener(sessionId, connection);
            agent.start();
            agents.put(sessionId, agent);
            return agent;
        }
        catch (IOException iOException) {
            throw new AgentNotAvailableException();
        }
    }
}

