/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.openssh.DSAKeyInfo;
import com.sshtools.j2ssh.openssh.PEMReader;
import com.sshtools.j2ssh.openssh.PEMWriter;
import com.sshtools.j2ssh.openssh.RSAKeyInfo;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.SimpleASNReader;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;

public class OpenSSHPrivateKeyFormat
implements SshPrivateKeyFormat {
    public String getFormatType() {
        return "OpenSSH-PrivateKey";
    }

    public String toString() {
        return this.getFormatType();
    }

    public byte[] decryptKeyblob(byte[] formattedKey, String passphrase) throws InvalidSshKeyException {
        try {
            StringReader r = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pem = new PEMReader(r);
            byte[] payload = pem.decryptPayload(passphrase);
            SimpleASNReader asn = new SimpleASNReader(payload);
            if ("DSA PRIVATE KEY".equals(pem.getType())) {
                DSAKeyInfo keyInfo = DSAKeyInfo.getDSAKeyInfo(asn);
                ByteArrayWriter baw = new ByteArrayWriter();
                baw.writeString("ssh-dss");
                baw.writeBigInteger(keyInfo.getP());
                baw.writeBigInteger(keyInfo.getQ());
                baw.writeBigInteger(keyInfo.getG());
                baw.writeBigInteger(keyInfo.getX());
                return baw.toByteArray();
            }
            if ("RSA PRIVATE KEY".equals(pem.getType())) {
                RSAKeyInfo keyInfo = RSAKeyInfo.getRSAKeyInfo(asn);
                ByteArrayWriter baw = new ByteArrayWriter();
                baw.writeString("ssh-rsa");
                baw.writeBigInteger(keyInfo.getPublicExponent());
                baw.writeBigInteger(keyInfo.getModulus());
                baw.writeBigInteger(keyInfo.getPrivateExponent());
                return baw.toByteArray();
            }
            throw new InvalidSshKeyException("Unsupported type: " + pem.getType());
        }
        catch (GeneralSecurityException e) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems: " + e);
        }
        catch (IOException e) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems: " + e);
        }
    }

    public byte[] encryptKeyblob(byte[] keyblob, String passphrase) throws InvalidSshKeyException {
        try {
            byte[] payload;
            ByteArrayReader bar = new ByteArrayReader(keyblob);
            String algorithm = bar.readString();
            PEMWriter pem = new PEMWriter();
            if ("ssh-dss".equals(algorithm)) {
                BigInteger p = bar.readBigInteger();
                BigInteger q = bar.readBigInteger();
                BigInteger g = bar.readBigInteger();
                BigInteger x = bar.readBigInteger();
                DSAKeyInfo keyInfo = new DSAKeyInfo(p, q, g, x, BigInteger.ZERO);
                SimpleASNWriter asn = new SimpleASNWriter();
                DSAKeyInfo.writeDSAKeyInfo(asn, keyInfo);
                payload = asn.toByteArray();
                pem.setType("DSA PRIVATE KEY");
            } else if ("ssh-rsa".equals(algorithm)) {
                BigInteger e = bar.readBigInteger();
                BigInteger n = bar.readBigInteger();
                BigInteger p = bar.readBigInteger();
                RSAKeyInfo keyInfo = new RSAKeyInfo(n, p, e, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO);
                SimpleASNWriter asn = new SimpleASNWriter();
                RSAKeyInfo.writeRSAKeyInfo(asn, keyInfo);
                payload = asn.toByteArray();
                pem.setType("RSA PRIVATE KEY");
            } else {
                throw new InvalidSshKeyException("Unsupported J2SSH algorithm: " + algorithm);
            }
            pem.setPayload(payload);
            pem.encryptPayload(payload, passphrase);
            StringWriter w = new StringWriter();
            pem.write(w);
            return w.toString().getBytes("US-ASCII");
        }
        catch (GeneralSecurityException e) {
            throw new InvalidSshKeyException("Can't read key due to cryptography problems: " + e);
        }
        catch (IOException e) {
            throw new InvalidSshKeyException("Can't read key due to internal IO problems: " + e);
        }
    }

    public boolean isFormatted(byte[] formattedKey) {
        try {
            StringReader r = new StringReader(new String(formattedKey, "US-ASCII"));
            new PEMReader(r);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isPassphraseProtected(byte[] formattedKey) {
        try {
            StringReader r = new StringReader(new String(formattedKey, "US-ASCII"));
            PEMReader pem = new PEMReader(r);
            return pem.getHeader().containsKey("DEK-Info");
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public boolean supportsAlgorithm(String algorithm) {
        return "ssh-dss".equals(algorithm) || "ssh-rsa".equals(algorithm);
    }
}

