/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.IOException;

public class SftpFile
implements Comparable {
    private String filename;
    private byte[] handle;
    private FileAttributes attrs;
    private SftpSubsystemClient sftp;
    private String absolutePath;

    public SftpFile(String absolutePath, FileAttributes attrs) {
        this.absolutePath = absolutePath;
        int i = absolutePath.lastIndexOf("/");
        this.filename = i > -1 ? absolutePath.substring(i + 1) : absolutePath;
        this.attrs = attrs;
    }

    public SftpFile(String absolutePath) {
        this(absolutePath, new FileAttributes());
    }

    public void delete() throws IOException {
        if (this.sftp == null) {
            throw new IOException("Instance not connected to SFTP subsystem");
        }
        if (this.isDirectory()) {
            this.sftp.removeDirectory(this.getAbsolutePath());
        } else {
            this.sftp.removeFile(this.getAbsolutePath());
        }
    }

    public void rename(String newFilename) throws IOException {
        if (this.sftp == null) {
            throw new IOException("Instance not connected to SFTP subsystem");
        }
        this.sftp.renameFile(String.valueOf(this.getAbsolutePath()) + this.filename, newFilename);
    }

    public boolean canWrite() {
        return (this.getAttributes().getPermissions().longValue() & 0x80L) == 128L;
    }

    public boolean canRead() {
        return (this.getAttributes().getPermissions().longValue() & 0x100L) == 256L;
    }

    public boolean isOpen() {
        if (this.sftp == null) {
            return false;
        }
        return this.sftp.isValidHandle(this.handle);
    }

    protected void setHandle(byte[] handle) {
        this.handle = handle;
    }

    protected byte[] getHandle() {
        return this.handle;
    }

    protected void setSFTPSubsystem(SftpSubsystemClient sftp) {
        this.sftp = sftp;
    }

    protected SftpSubsystemClient getSFTPSubsystem() {
        return this.sftp;
    }

    public String getFilename() {
        return this.filename;
    }

    private String pad(int num) {
        String str = "";
        if (num > 0) {
            int i = 0;
            while (i < num) {
                str = String.valueOf(str) + " ";
                ++i;
            }
        }
        return str;
    }

    public String getLongname() {
        StringBuffer str = new StringBuffer();
        str.append(String.valueOf(this.pad(10 - this.getAttributes().getPermissionsString().length())) + this.getAttributes().getPermissionsString());
        str.append("   1 ");
        str.append(String.valueOf(this.getAttributes().getUID().toString()) + this.pad(8 - this.getAttributes().getUID().toString().length()));
        str.append(" ");
        str.append(String.valueOf(this.getAttributes().getGID().toString()) + this.pad(8 - this.getAttributes().getGID().toString().length()));
        str.append(" ");
        str.append(String.valueOf(this.pad(8 - this.getAttributes().getSize().toString().length())) + this.getAttributes().getSize().toString());
        str.append(" ");
        str.append(String.valueOf(this.pad(12 - this.getAttributes().getModTimeString().length())) + this.getAttributes().getModTimeString());
        str.append(" ");
        str.append(this.filename);
        return str.toString();
    }

    public FileAttributes getAttributes() {
        try {
            if (this.attrs == null) {
                this.attrs = this.sftp.getAttributes(this);
            }
        }
        catch (IOException iOException) {
            this.attrs = new FileAttributes();
        }
        return this.attrs;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void close() throws IOException {
        this.sftp.closeFile(this);
    }

    public boolean isDirectory() {
        return this.getAttributes().isDirectory();
    }

    public boolean isFile() {
        return this.getAttributes().isFile();
    }

    public boolean isLink() {
        return this.getAttributes().isLink();
    }

    public boolean isFifo() {
        return this.getAttributes().isFifo();
    }

    public boolean isBlock() {
        return this.getAttributes().isBlock();
    }

    public boolean isCharacter() {
        return this.getAttributes().isCharacter();
    }

    public boolean isSocket() {
        return this.getAttributes().isSocket();
    }

    public int compareTo(Object o) {
        return this.getFilename().compareTo(((SftpFile)o).getFilename());
    }
}

