/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.ServiceState;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.SshMsgServiceAccept;
import com.sshtools.j2ssh.transport.TransportProtocol;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Service {
    private static Log log = LogFactory.getLog(Service.class);
    public static final int REQUESTING_SERVICE = 1;
    public static final int ACCEPTING_SERVICE = 2;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected TransportProtocol transport;
    protected Integer startMode = null;
    protected ServiceState state = new ServiceState();
    private String serviceName;

    public Service(String serviceName) {
        this.serviceName = serviceName;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final void start() throws IOException {
        if (this.startMode == null) {
            throw new IOException("Service must be initialized first!");
        }
        if (this.startMode == 1) {
            log.info((Object)(String.valueOf(this.serviceName) + " has been accepted"));
            this.onServiceAccept();
        } else {
            log.info((Object)(String.valueOf(this.serviceName) + " has been requested"));
            this.onServiceRequest();
        }
        this.onStart();
        this.state.setValue(2);
    }

    protected abstract void onStart() throws IOException;

    public ServiceState getState() {
        return this.state;
    }

    public void init(int startMode, TransportProtocol transport) throws IOException {
        if (startMode != 1 && startMode != 2) {
            throw new IOException("Invalid start mode!");
        }
        this.transport = transport;
        this.startMode = new Integer(startMode);
        this.onServiceInit(startMode);
        transport.addMessageStore(this.messageStore);
    }

    public final void stop() {
        this.messageStore.close();
        this.state.setValue(3);
    }

    protected abstract void onServiceAccept() throws IOException;

    protected abstract void onServiceInit(int var1) throws IOException;

    protected abstract void onServiceRequest() throws IOException;

    protected void sendServiceAccept() throws IOException {
        SshMsgServiceAccept msg = new SshMsgServiceAccept(this.serviceName);
        this.transport.sendMessage(msg, this);
    }
}

