/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPublicKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;

    static {
        formatTypes = new HashMap();
        log = LogFactory.getLog(SshPublicKeyFormatFactory.class);
        types = new Vector();
        ArrayList<String> formats = new ArrayList<String>();
        formats.add(SECSHPublicKeyFormat.class.getName());
        formats.add(OpenSSHPublicKeyFormat.class.getName());
        defaultFormat = "SECSH-PublicKey-Base64Encoded";
        try {
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class)) {
                SshAPIConfiguration config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class);
                defaultFormat = config.getDefaultPublicKeyFormat();
                formats.addAll(config.getPublicKeyFormats());
            }
        }
        catch (ConfigurationException configurationException) {}
        log.debug((Object)("Default public key format will be " + defaultFormat));
        for (String classname : formats) {
            try {
                Class cls = ConfigurationLoader.getExtensionClass(classname);
                SshPublicKeyFormat f = (SshPublicKeyFormat)cls.newInstance();
                log.debug((Object)("Installing " + f.getFormatType() + " public key format"));
                formatTypes.put(f.getFormatType(), cls);
                types.add(f.getFormatType());
            }
            catch (Exception iae) {
                log.warn((Object)("Public key format implemented by " + classname + " will not be available"), (Throwable)iae);
            }
        }
    }

    public static List getSupportedFormats() {
        return types;
    }

    public static SshPublicKeyFormat newInstance(String type) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(type)) {
                return (SshPublicKeyFormat)((Class)formatTypes.get(type)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + type + " is not supported");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + type);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + type);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }
}

