/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hash {
    private MessageDigest hash;

    public Hash(String algorithm) throws NoSuchAlgorithmException {
        this.hash = MessageDigest.getInstance(algorithm);
    }

    public void putBigInteger(BigInteger bi) {
        byte[] data = bi.toByteArray();
        this.putInt(data.length);
        this.hash.update(data);
    }

    public void putByte(byte b) {
        this.hash.update(b);
    }

    public void putBytes(byte[] data) {
        this.hash.update(data);
    }

    public void putInt(int i) {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeInt(i);
        }
        catch (IOException iOException) {}
        this.hash.update(baw.toByteArray());
    }

    public void putString(String str) {
        this.putInt(str.length());
        this.hash.update(str.getBytes());
    }

    public void reset() {
        this.hash.reset();
    }

    public static byte[] simple(byte[] data, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest simp = MessageDigest.getInstance(algorithm);
        simp.update(data);
        return simp.digest();
    }

    public byte[] doFinal() {
        return this.hash.digest();
    }
}

