/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106;

import edu.stanford.cs106.CS106Plugin;
import edu.stanford.cs106.CommitMessageHandler;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.JGitInternalException;
import org.eclipse.jgit.api.NoFilepatternException;
import org.eclipse.jgit.api.NoHeadException;
import org.eclipse.jgit.api.NoMessageException;
import org.eclipse.jgit.api.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;

public class LogChangeListener
implements IResourceChangeListener {
    public static final int MAX_REPO_SIZE = 10000000;
    private static final int COMMIT_SLEEP_MS = 5000;
    private static final int CLASS_MODIFIED = 2;
    private static final int FILE_ADDED = 4;
    private static final int FILE_REMOVED = 8;
    private static final int TIMER_EVENT = 22;
    private boolean disabledDueToError = false;
    private CommitMessageHandler commitMessageHandler;

    public LogChangeListener(CommitMessageHandler handler) {
        this.commitMessageHandler = handler;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        System.out.println(event.getType());
        System.out.println("resource changed");
        if (this.disabledDueToError) {
            System.out.println("disabled due to error");
            return;
        }
        try {
            IResourceDelta[] deltaChildren;
            if (event.getType() != 1) {
                return;
            }
            IProject modifiedProject = null;
            int modifiedFlag = 0;
            IResourceDelta[] iResourceDeltaArray = deltaChildren = event.getDelta().getAffectedChildren();
            int n = deltaChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                IProject project = (IProject)childDelta.getResource().getAdapter(IProject.class);
                if (!project.equals(modifiedProject)) {
                    System.out.println("Project change modified flags " + modifiedFlag);
                    if (modifiedProject != null && modifiedFlag != 0) {
                        System.out.println("commit to git!");
                        this.commitProjectToGit(modifiedProject, modifiedFlag);
                    }
                    modifiedProject = project;
                    modifiedFlag = 0;
                }
                if (project != null && this.isStanfordProject(project)) {
                    System.out.println("win");
                    Repository repo = this.getRepository(project);
                    if (repo == null) {
                        this.disabledDueToError = true;
                        return;
                    }
                    modifiedFlag |= this.processDelta(repo, project, childDelta);
                }
                ++n2;
            }
            System.out.println("Final modified flags " + modifiedFlag);
            if (modifiedProject != null && modifiedFlag != 0) {
                this.commitProjectToGit(modifiedProject, modifiedFlag);
            }
        }
        catch (IOException ioe) {
            CS106Plugin.getDefault().getLog().log((IStatus)new Status(4, "edu.stanford.cs106", "IOException", (Throwable)ioe));
            this.disabledDueToError = true;
        }
    }

    private long sizeOfDirectory(File f) {
        if (f.isDirectory()) {
            int size = 0;
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File m = fileArray[n2];
                size = (int)((long)size + this.sizeOfDirectory(m));
                ++n2;
            }
            return size;
        }
        return f.length();
    }

    private Repository getRepository(IProject project) throws IOException {
        File repositoryDir = new File(project.getRawLocation().toFile(), ".git");
        long dirSize = this.sizeOfDirectory(repositoryDir);
        System.out.println("Repository dir  " + repositoryDir + " size " + dirSize);
        if (dirSize > 10000000L) {
            return null;
        }
        FileRepository repository = new FileRepository(repositoryDir);
        if (!repositoryDir.exists()) {
            System.out.println("Creating");
            repository.create();
        }
        return repository;
    }

    private void processChange(Repository repo, IProject project, IResourceDelta delta) {
        IPath modifiedPath = delta.getResource().getLocation();
        try {
            String relativePath = modifiedPath.toFile().getAbsolutePath().substring(project.getLocation().toFile().getAbsolutePath().length() + 1);
            if (relativePath.endsWith(".class")) {
                relativePath = String.valueOf(relativePath.substring(0, relativePath.lastIndexOf(".class"))) + ".java";
            }
            System.out.println("Project path " + project.getLocation().toFile().getAbsolutePath());
            System.out.println("Modified path " + modifiedPath.toFile().getAbsolutePath());
            System.out.println("Relative path " + relativePath);
            if (delta.getKind() == 2) {
                try {
                    System.out.println("RM " + repo.getDirectory().getParentFile() + " " + new File(repo.getDirectory().getParentFile(), relativePath));
                    DirCache dirCache = repo.lockDirCache();
                    DirCacheEditor editor = dirCache.editor();
                    editor.add(new DirCacheEditor.DeletePath(relativePath));
                    editor.commit();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                new AddCommand(repo).addFilepattern(relativePath).call();
            }
        }
        catch (NoFilepatternException e) {
            e.printStackTrace();
        }
    }

    private int processDelta(Repository repo, IProject project, IResourceDelta delta) {
        IResourceDelta[] deltaChildren;
        int modifiedFlag = 0;
        if (this.isExtension(delta, "class")) {
            switch (delta.getKind()) {
                case 1: {
                    modifiedFlag |= 4;
                    break;
                }
                case 4: {
                    modifiedFlag |= 2;
                    break;
                }
                case 2: {
                    modifiedFlag |= 8;
                }
            }
            this.processChange(repo, project, delta);
        }
        IResourceDelta[] iResourceDeltaArray = deltaChildren = delta.getAffectedChildren();
        int n = deltaChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            modifiedFlag |= this.processDelta(repo, project, childDelta);
            ++n2;
        }
        return modifiedFlag;
    }

    private Repository commitProjectToGit(IProject project, int modifiedFlag) throws IOException, UnmergedPathException {
        Repository repo = this.getRepository(project);
        if (repo == null) {
            return null;
        }
        try {
            if ((modifiedFlag & 2) != 0) {
                this.commitMessageHandler.setType("SWC");
            }
            if ((modifiedFlag & 4) != 0) {
                this.commitMessageHandler.setType("FA");
            }
            if ((modifiedFlag & 8) != 0) {
                this.commitMessageHandler.setType("FR");
            }
            if ((modifiedFlag & 0x16) != 0) {
                this.commitMessageHandler.setType("TI");
            }
            new Git(repo).commit().setAuthor("S", "s").setCommitter("S", "s").setMessage(this.commitMessageHandler.getMessage()).call();
            this.commitMessageHandler.clear();
            System.out.println("Version committed");
        }
        catch (NoHeadException e) {
            e.printStackTrace();
        }
        catch (NoMessageException e) {
            e.printStackTrace();
        }
        catch (ConcurrentRefUpdateException e) {
            e.printStackTrace();
        }
        catch (JGitInternalException e) {
            e.printStackTrace();
        }
        catch (WrongRepositoryStateException e) {
            e.printStackTrace();
        }
        return repo;
    }

    private boolean isExtension(IResourceDelta delta, String expectedExtension) {
        if (delta == null || delta.getResource() == null) {
            return false;
        }
        if (delta.getResource().getLocation() == null) {
            return false;
        }
        IPath modifiedPath = delta.getResource().getLocation();
        if (modifiedPath == null) {
            return false;
        }
        String extension = modifiedPath.getFileExtension();
        return extension != null && extension.equals(expectedExtension);
    }

    private boolean isStanfordProject(IProject project) {
        System.out.println("Project:" + project.getFullPath());
        if (project.findMember("acm.jar") != null) {
            return true;
        }
        return project.findMember("karel.jar") != null;
    }

    void getErrorsAndWarnings(IResourceDelta delta) {
        try {
            IMarker[] problemMarkers;
            IMarker[] iMarkerArray = problemMarkers = delta.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = problemMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.getAttribute("severity", -1) == 1) {
                    // empty if block
                }
                if (marker.getAttribute("severity", -1) == 2) {
                    // empty if block
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    class CommitTimer
    extends Thread {
        private LogChangeListener changeListener;

        public CommitTimer(LogChangeListener changeListener) {
            this.changeListener = changeListener;
        }

        private IProject[] getActiveProjects() {
            return ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }

        private void commitProject(IProject project) throws UnmergedPathException, IOException {
            File repositoryDir = new File(project.getRawLocation().toFile(), ".git");
            long dirSize = LogChangeListener.this.sizeOfDirectory(repositoryDir);
            System.out.println("Repository dir  " + repositoryDir + " size " + dirSize);
            int modifiedFlag = 0;
            this.changeListener.commitProjectToGit(project, modifiedFlag);
        }

        public void run() {
            block2: while (true) {
                System.out.println("HELLO WORLD");
                try {
                    IProject[] currentProjects;
                    CommitTimer.sleep(5000L);
                    IProject[] iProjectArray = currentProjects = this.getActiveProjects();
                    int n = currentProjects.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block2;
                        IProject project = iProjectArray[n2];
                        this.commitProject(project);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

