/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106;

import edu.stanford.cs106.CS106Plugin;
import edu.stanford.cs106.CommitMessageHandler;
import edu.stanford.cs106.LogChangeListener;
import edu.stanford.cs106.LogLaunchListener;
import edu.stanford.cs106.PoorLifeChoicesListener;
import edu.stanford.cs106.ResourceFilterListener;
import edu.stanford.cs106.ThreadFilterListener;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.intro.IIntroManager;

public class StartupListener
implements IStartup {
    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IIntroManager manager = CS106Plugin.getDefault().getWorkbench().getIntroManager();
                if (manager.getIntro() != null) {
                    manager.closeIntro(manager.getIntro());
                }
            }
        });
        IPreferencesService prefs = Platform.getPreferencesService();
        if (prefs.getBoolean("edu.stanford.cs106", "poorLifeChoicesProtection", false, null)) {
            new PoorLifeChoicesListener();
        }
        if (prefs.getBoolean("edu.stanford.cs106", "threadFiltering", true, null)) {
            new ThreadFilterListener();
        }
        if (prefs.getBoolean("edu.stanford.cs106", "resourceFiltering", false, null)) {
            System.out.println("Resource filtering enabled");
            new ResourceFilterListener();
        }
        CommitMessageHandler commitMessage = new CommitMessageHandler();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)new LogChangeListener(commitMessage));
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchListener((ILaunchesListener)new LogLaunchListener(commitMessage));
    }
}

