/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Assignment {
    private Date dueDate;
    private String name;
    private String course;
    private String dirName;
    private boolean contest = false;
    private boolean log = false;

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getName() {
        return this.name;
    }

    public String getDirectory() {
        return this.dirName;
    }

    public String getCourse() {
        return this.course;
    }

    public Assignment(String course, JSONObject description) {
        this.course = course;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        try {
            this.name = description.getString("Name");
            this.dueDate = formatter.parse(description.getString("DueDate"));
            this.dirName = description.getString("DirectoryName");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return String.valueOf(this.course) + " > " + this.name + " (" + this.dueDate + ")";
    }

    public boolean isContest() {
        return this.contest;
    }

    public boolean shouldLog() {
        return this.log;
    }
}

