/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.Assignment;
import edu.stanford.cs106.submitter.AuthenticationCallback;
import edu.stanford.cs106.submitter.SubmissionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentAuthenticationCallback
extends AuthenticationCallback {
    private HashMap<String, String> slInfo;
    private ArrayList<Assignment> assignmentInfo;

    public ArrayList<Assignment> getAssignmentInfo() {
        ArrayList<Assignment> selectedAssignments = new ArrayList<Assignment>();
        for (Assignment assn : this.assignmentInfo) {
            selectedAssignments.add(assn);
        }
        return selectedAssignments;
    }

    public HashMap<String, String> getSlInfo() {
        return this.slInfo;
    }

    private String getSectionLeader(String slURLBase) throws IOException {
        System.out.println("SL URL BASE: " + slURLBase);
        this.slInfo = new HashMap();
        String sl = "unknown";
        try {
            URL slURL = new URL(String.valueOf(slURLBase) + this.username);
            BufferedReader rd = new BufferedReader(new InputStreamReader(slURL.openStream()));
            String result = rd.readLine();
            if (result != null) {
                sl = result;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return sl;
    }

    private JSONArray getAssignmentJSONArray(String url) throws IOException {
        JSONArray array;
        System.out.println("THE ASSN URL: " + url);
        URL assnURL = new URL(url);
        InputStream assnMapStream = assnURL.openStream();
        try {
            array = new JSONArray(new JSONTokener(new InputStreamReader(assnMapStream)));
            System.out.println("Got JSON object in Student Authentication Callback: ");
            System.out.println(array);
        }
        catch (JSONException e) {
            throw new IOException("JSON Parsing error: " + e.getLocalizedMessage());
        }
        return array;
    }

    public void addClass(String course, String slName) {
        this.slInfo.put(course, slName);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.assignmentInfo = new ArrayList();
        try {
            this.ssh.openSftpChannel();
            SubmissionInfo submissionInfo = SubmissionInfo.getInstance();
            String course = submissionInfo.getCourse();
            String filename = submissionInfo.getAssignmentMapDir();
            String slURLBase = submissionInfo.getSLURLBase();
            System.out.println(filename);
            System.out.println("Trying to get new ASSN JSON");
            String assignmentURL = submissionInfo.getAssignmentsURL();
            JSONArray curAssignmentInfo = this.getAssignmentJSONArray(assignmentURL);
            int i = 0;
            while (i < curAssignmentInfo.length()) {
                try {
                    this.assignmentInfo.add(new Assignment(course, curAssignmentInfo.getJSONObject(i)));
                }
                catch (JSONException e) {
                    this.errorMessage = "Couldn't get assignment listings for course " + course + ". Please contact the course TA." + e.getLocalizedMessage();
                    return;
                }
                ++i;
            }
            try {
                String sl = this.getSectionLeader(slURLBase);
                System.out.println("THE SECTION LEADER: " + sl);
                this.addClass("cs106a", sl);
                monitor.worked(1);
            }
            catch (IOException iOException) {
                this.addClass("cs106a", "unknown");
            }
        }
        catch (IOException e1) {
            this.errorMessage = "Couldn't get assignment listings for your course. Please contact the course TA. " + e1.getLocalizedMessage();
            return;
        }
        this.successful = true;
    }
}

