/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmissionInfo {
    private String COURSE = "cs106a";
    private String submitHost;
    private String slMapDir;
    private String assignmentMapDir;
    private String submissionDir;
    private String slURLBase;
    private String assignmentURL;
    private List<String> depricatedPlugins = new ArrayList<String>();
    private boolean loggingOn;
    private String loggingSubmitDir;
    protected static boolean initSuccessful = false;
    protected static SubmissionInfo instance = null;

    private SubmissionInfo() throws IOException {
        URL dirMapURL = new URL("http://CS106a.stanford.edu/submitter/submitterInfoTest.json");
        InputStream dirMapStream = dirMapURL.openStream();
        try {
            JSONObject obj = new JSONObject(new JSONTokener(new InputStreamReader(dirMapStream)));
            System.out.println("Got JSON object in Submission Info: ");
            System.out.println(obj);
            this.submitHost = obj.getString("submit_host");
            this.slMapDir = obj.getString("sl_map_dir");
            this.assignmentMapDir = obj.getString("assignment_map_dir");
            this.assignmentURL = obj.getString("assignments_url");
            this.slURLBase = obj.getString("sl_url_base");
            this.submissionDir = obj.getString("submission_dir");
            this.loadDepricatedPlugins(obj.getJSONArray("deprecated_submitters"));
            this.loggingOn = obj.getString("logging_on").equals("true");
            this.loggingSubmitDir = obj.getString("logging_submit_dir");
            initSuccessful = true;
        }
        catch (JSONException e) {
            throw new IOException("JSON Parsing error: " + e.getLocalizedMessage());
        }
    }

    private void loadDepricatedPlugins(JSONArray depricatedPluginsObj) throws JSONException {
        int i = 0;
        while (i < depricatedPluginsObj.length()) {
            JSONObject depricatedPlugin = depricatedPluginsObj.getJSONObject(i);
            String name = depricatedPlugin.getString("code_name");
            System.out.println("depricated: " + name);
            this.depricatedPlugins.add(name);
            ++i;
        }
    }

    public static SubmissionInfo getInstance() throws IOException {
        if (initSuccessful) {
            return instance;
        }
        instance = new SubmissionInfo();
        return instance;
    }

    public String getCourse() {
        return this.COURSE;
    }

    public String getSlMapDirectory() {
        return this.slMapDir;
    }

    public List<String> getDepricatedPlugins() {
        return this.depricatedPlugins;
    }

    public String getSubmitHost() {
        return this.submitHost;
    }

    public String getSlMapDir() {
        return this.slMapDir;
    }

    public String getSLURLBase() {
        return this.slURLBase;
    }

    public String getAssignmentsURL() {
        return this.assignmentURL;
    }

    public String getAssignmentMapDir() {
        return this.assignmentMapDir;
    }

    public String getSubmissionDir() {
        return this.submissionDir;
    }

    public boolean isLoggingOn() {
        return this.loggingOn;
    }

    public String getLoggingSubmitDir() {
        return this.loggingSubmitDir;
    }
}

