/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.sftp.SftpFile;
import edu.stanford.cs106.submitter.Assignment;
import edu.stanford.cs106.submitter.ISubmissionProducer;
import edu.stanford.cs106.submitter.ProjectCopyException;
import edu.stanford.cs106.submitter.SubmissionInfo;
import edu.stanford.cs106.submitter.SubmitterWizard;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitAction
implements IRunnableWithProgress {
    private static final int EXTRA_GIT_FILES = 1;
    private static final int EXTRA_SUBMISSION_FILES = 1;
    SubmitterWizard wizard;
    boolean success;

    public SubmitAction(SubmitterWizard wizard) {
        this.wizard = wizard;
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SftpClient sftp;
        this.success = false;
        try {
            sftp = this.wizard.authenticationPage.getClient().openSftpClient();
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.wizard.getShell(), (String)"Couldn't Authenticate", (String)("There was an error communicating with the submission server. Please try authenticating again." + e.getLocalizedMessage()));
            return;
        }
        try {
            Assignment assignmentToSubmit = this.wizard.assignmentSelectPage.getSelectedAssignment();
            String submissionsDir = SubmissionInfo.getInstance().getSubmissionDir();
            if (!assignmentToSubmit.isContest()) {
                submissionsDir = String.valueOf(submissionsDir) + "/" + this.wizard.authenticationPage.getSectionLeader(assignmentToSubmit.getCourse());
            }
            String submitterName = this.wizard.authenticationPage.getSUNetID();
            String submissionRoot = String.valueOf(submissionsDir) + "/" + assignmentToSubmit.getDirectory();
            sftp.mkdirs(submissionRoot);
            int submissionNumber = this.getSubmissionNumber(sftp, submitterName, submissionRoot);
            String folderName = String.valueOf(submitterName) + "_" + submissionNumber;
            String submissionDir = String.valueOf(submissionRoot) + "/" + folderName;
            System.out.println("Submission dir: " + submissionDir);
            sftp.mkdirs(submissionDir);
            ISubmissionProducer submissionProducer = this.wizard.getSubmissionProducer();
            File[] projectFiles = submissionProducer.getSelectedFiles();
            ArrayList<File> gitFiles = new ArrayList<File>();
            ArrayList<File> submissionFiles = new ArrayList<File>();
            this.categorizeFiles(projectFiles, gitFiles, submissionFiles);
            boolean submitGit = this.shouldSubmitGitFiles(assignmentToSubmit);
            if (submitGit) {
                System.out.println("attempt to submit git");
            }
            int numFiles = this.getNumFilesToSend(projectFiles, submissionFiles, submitGit);
            monitor.beginTask("Sending files...", numFiles);
            this.submitProjectFiles(monitor, sftp, submissionDir, folderName, submissionProducer, submissionFiles);
            this.addLateDayFile(monitor, sftp, submissionDir, assignmentToSubmit);
            if (submitGit) {
                this.submitGitFiles(monitor, sftp, submitterName, submissionProducer, assignmentToSubmit, gitFiles);
            }
            MessageDialog.openInformation((Shell)this.wizard.getShell(), (String)"Submission Successful", (String)"Congratulations, your assignment was submitted successfully.");
            this.success = true;
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.wizard.getShell(), (String)"Couldn't Authenticate", (String)("There was an error communicating with the submission server.Please try again, and email the course staff if the problem continues." + e.getLocalizedMessage()));
        }
        catch (ProjectCopyException projectCopyException) {
            MessageDialog.openError((Shell)this.wizard.getShell(), (String)"Failed to Send", (String)"There was a problem copying your .project file");
        }
    }

    private int getNumFilesToSend(File[] projectFiles, List<File> submissionFiles, boolean submitGit) {
        if (submitGit) {
            return projectFiles.length + 1 + 1;
        }
        return submissionFiles.size() + 1;
    }

    private boolean shouldSubmitGitFiles(Assignment assignment) {
        try {
            boolean cs106aAgrees = SubmissionInfo.getInstance().isLoggingOn();
            return cs106aAgrees;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void submitGitFiles(IProgressMonitor monitor, SftpClient sftp, String submitterName, ISubmissionProducer submissionProducer, Assignment assignment, List<File> gitFiles) {
        try {
            String gitRoot = String.valueOf(SubmissionInfo.getInstance().getLoggingSubmitDir()) + "/" + assignment.getDirectory();
            sftp.mkdirs(gitRoot);
            int submissionNumber = this.getSubmissionNumber(sftp, submitterName, gitRoot);
            String folderName = String.valueOf(submitterName) + "_" + submissionNumber;
            String gitDir = String.valueOf(gitRoot) + "/" + folderName;
            sftp.mkdirs(gitDir);
            for (File gitFile : gitFiles) {
                String localFilenameRelative = gitFile.getAbsolutePath().substring(submissionProducer.getRoot().length() + 1);
                localFilenameRelative = localFilenameRelative.replace('\\', '/');
                String remoteFilename = String.valueOf(gitDir) + "/" + localFilenameRelative;
                sftp.mkdirs(remoteFilename.substring(0, remoteFilename.lastIndexOf("/")));
                this.submitFile(sftp, remoteFilename, gitFile);
                monitor.worked(1);
            }
            String infoText = "";
            infoText = String.valueOf(infoText) + "suid: " + submitterName + "\n";
            infoText = String.valueOf(infoText) + "assignment: " + assignment.getName() + "\n";
            infoText = String.valueOf(infoText) + this.getLateDayText(assignment);
            ByteArrayInputStream in = new ByteArrayInputStream(infoText.getBytes());
            String remoteFilename = String.valueOf(gitDir) + "/info.txt";
            sftp.put(in, remoteFilename);
            monitor.worked(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void submitProjectFiles(IProgressMonitor monitor, SftpClient sftp, String submissionDir, String folderName, ISubmissionProducer submissionProducer, List<File> submissionFiles) throws ProjectCopyException, IOException {
        for (File submitFile : submissionFiles) {
            String localFilenameRelative = submitFile.getAbsolutePath().substring(submissionProducer.getRoot().length() + 1);
            localFilenameRelative = localFilenameRelative.replace('\\', '/');
            String remoteFilename = String.valueOf(submissionDir) + "/" + localFilenameRelative;
            sftp.mkdirs(remoteFilename.substring(0, remoteFilename.lastIndexOf("/")));
            if (submitFile.getName().equals(".project")) {
                this.submitProjectFile(sftp, remoteFilename, submitFile, folderName);
            } else {
                this.submitFile(sftp, remoteFilename, submitFile);
            }
            monitor.worked(1);
        }
    }

    private void categorizeFiles(File[] projectFiles, List<File> gitFiles, List<File> submissionFiles) {
        File[] fileArray = projectFiles;
        int n = projectFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isGitFile(file)) {
                gitFiles.add(file);
            } else {
                submissionFiles.add(file);
            }
            ++n2;
        }
    }

    private int getSubmissionNumber(SftpClient sftp, String submitterName, String root) throws IOException {
        List submittedDirs = sftp.ls(root);
        TreeSet<String> submittedDirNames = new TreeSet<String>();
        for (SftpFile submittedDir : submittedDirs) {
            submittedDirNames.add(submittedDir.getFilename());
        }
        Iterator nameIt = submittedDirNames.tailSet(submitterName).iterator();
        int greatestNumber = 0;
        while (nameIt.hasNext()) {
            int lastUnderscoreIndex;
            String curName = (String)nameIt.next();
            if (!curName.startsWith(submitterName) || (lastUnderscoreIndex = curName.lastIndexOf(95)) == -1 || lastUnderscoreIndex + 1 == curName.length()) continue;
            String numPart = curName.substring(lastUnderscoreIndex + 1);
            try {
                int number = Integer.parseInt(numPart);
                if (number <= greatestNumber) continue;
                greatestNumber = number;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return greatestNumber + 1;
    }

    private void submitFile(SftpClient sftp, String remoteFileName, File submitFile) throws IOException {
        String localFilename = submitFile.getAbsolutePath();
        System.out.println(String.valueOf(localFilename) + " -> " + remoteFileName);
        sftp.put(localFilename, remoteFileName);
    }

    private void submitProjectFile(SftpClient sftp, String remoteFilename, File projectFile, String folderName) throws ProjectCopyException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(projectFile);
            Element root = doc.getDocumentElement();
            System.out.println("root tag: " + root.getTagName());
            Node nameNode = root.getElementsByTagName("name").item(0);
            System.out.println("name node tag: " + nameNode.getNodeName());
            System.out.println("name node type: " + nameNode.getNodeType());
            String oldName = nameNode.getTextContent();
            System.out.println("old name: " + oldName);
            nameNode.setTextContent(String.valueOf(oldName) + "_" + folderName);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
            String xmlString = sw.toString();
            System.out.println(xmlString);
            ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
            sftp.put(in, remoteFilename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addLateDayFile(IProgressMonitor monitor, SftpClient sftp, String submissionDir, Assignment assignment) throws IOException {
        String lateDayText = this.getLateDayText(assignment);
        ByteArrayInputStream in = new ByteArrayInputStream(lateDayText.getBytes());
        String remoteFilename = String.valueOf(submissionDir) + "/lateDays.txt";
        remoteFilename = remoteFilename.replace('\\', '/');
        sftp.put(in, remoteFilename);
        monitor.worked(1);
    }

    private String getLateDayText(Assignment assignment) {
        Date nowDate = new Date(System.currentTimeMillis());
        Date dueDate = assignment.getDueDate();
        String nowDateString = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss").format(nowDate);
        String dueDateString = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss").format(dueDate);
        String lateDayText = "";
        lateDayText = String.valueOf(lateDayText) + "student_submission_time: " + nowDateString + "\n";
        lateDayText = String.valueOf(lateDayText) + "assignment_due_time: " + dueDateString + "\n";
        return lateDayText;
    }

    private boolean isGitFile(File file) {
        return file.getAbsolutePath().contains(".git");
    }
}

