/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.merge.MergeStrategy;

public class MergeResult {
    private ObjectId newHead;
    private MergeStatus mergeStatus;
    private String description;
    private MergeStrategy mergeStrategy;

    public MergeResult(ObjectId newHead, MergeStatus mergeStatus, MergeStrategy mergeStrategy) {
        this.newHead = newHead;
        this.mergeStatus = mergeStatus;
        this.mergeStrategy = mergeStrategy;
    }

    public MergeResult(ObjectId newHead, MergeStatus mergeStatus, MergeStrategy mergeStrategy, String description) {
        this.newHead = newHead;
        this.mergeStatus = mergeStatus;
        this.mergeStrategy = mergeStrategy;
        this.description = description;
    }

    public ObjectId getNewHead() {
        return this.newHead;
    }

    public MergeStatus getMergeStatus() {
        return this.mergeStatus;
    }

    public String toString() {
        return MessageFormat.format(JGitText.get().mergeUsingStrategyResultedInDescription, new Object[]{this.mergeStrategy.getName(), this.mergeStatus, this.description == null ? "" : ", " + this.description});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MergeStatus {
        FAST_FORWARD{

            public String toString() {
                return "Fast-forward";
            }
        }
        ,
        ALREADY_UP_TO_DATE{

            public String toString() {
                return "Already-up-to-date";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "Failed";
            }
        }
        ,
        MERGED{

            public String toString() {
                return "Merged";
            }
        }
        ,
        NOT_SUPPORTED{

            public String toString() {
                return "Not-yet-supported";
            }
        };

    }
}

