/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;

public class RawText
implements Sequence {
    public static final Factory FACTORY = new Factory(){

        public RawText create(byte[] input) {
            return new RawText(input);
        }
    };
    private static final int FIRST_FEW_BYTES = 8000;
    protected final byte[] content;
    protected final IntList lines;
    protected final IntList hashes;

    public RawText(byte[] input) {
        this.content = input;
        this.lines = RawParseUtils.lineMap(this.content, 0, this.content.length);
        this.hashes = this.computeHashes();
    }

    public RawText(File file) throws IOException {
        this(IO.readFully(file));
    }

    public int size() {
        return this.lines.size() - 2;
    }

    public boolean equals(int i, Sequence other, int j) {
        return RawText.equals(this, i + 1, (RawText)other, j + 1);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean equals(RawText a, int ai, RawText b, int bi) {
        if (a.hashes.get(ai) != b.hashes.get(bi)) {
            return false;
        }
        as = a.lines.get(ai);
        bs = b.lines.get(bi);
        ae = a.lines.get(ai + 1);
        if (ae - as == (be = b.lines.get(bi + 1)) - bs) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (a.content[as++] == b.content[bs++]) continue;
            return false;
lbl10:
            // 2 sources

            ** while (as < ae)
        }
lbl11:
        // 1 sources

        return true;
    }

    public void writeLine(OutputStream out, int i) throws IOException {
        int start = this.lines.get(i + 1);
        int end = this.lines.get(i + 2);
        if (this.content[end - 1] == 10) {
            --end;
        }
        out.write(this.content, start, end - start);
    }

    public boolean isMissingNewlineAtEnd() {
        int end = this.lines.get(this.lines.size() - 1);
        if (end == 0) {
            return true;
        }
        return this.content[end - 1] != 10;
    }

    private IntList computeHashes() {
        IntList r = new IntList(this.lines.size());
        r.add(0);
        int lno = 1;
        while (lno < this.lines.size() - 1) {
            int ptr = this.lines.get(lno);
            int end = this.lines.get(lno + 1);
            r.add(this.hashLine(this.content, ptr, end));
            ++lno;
        }
        r.add(0);
        return r;
    }

    protected int hashLine(byte[] raw, int ptr, int end) {
        int hash = 5381;
        while (ptr < end) {
            hash = hash << 5 ^ raw[ptr] & 0xFF;
            ++ptr;
        }
        return hash;
    }

    public static boolean isBinary(byte[] raw) {
        int size = raw.length > 8000 ? 8000 : raw.length;
        int ptr = 0;
        while (ptr < size) {
            if (raw[ptr] == 0) {
                return true;
            }
            ++ptr;
        }
        return false;
    }

    public static interface Factory {
        public RawText create(byte[] var1);
    }
}

