/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;

class SimilarityIndex {
    private static final int MAX_HASH_BITS = 17;
    private static final int MAX_HASH_SIZE = 131072;
    private static final int P = 131071;
    private static final int KEY_SHIFT = 46;
    private long fileSize;
    private int idSize;
    private long[] idHash = new long[256];

    SimilarityIndex() {
    }

    long getFileSize() {
        return this.fileSize;
    }

    void setFileSize(long size) {
        this.fileSize = size;
    }

    void hash(ObjectLoader obj) throws MissingObjectException, IOException {
        if (obj.isLarge()) {
            ObjectStream in = obj.openStream();
            try {
                this.setFileSize(in.getSize());
                this.hash(in, this.fileSize);
            }
            finally {
                in.close();
            }
        } else {
            byte[] raw = obj.getCachedBytes();
            this.setFileSize(raw.length);
            this.hash(raw, 0, raw.length);
        }
    }

    void hash(byte[] raw, int ptr, int end) {
        while (ptr < end) {
            int c;
            int hash = 5381;
            int start = ptr;
            while ((c = raw[ptr++] & 0xFF) != 10) {
                hash = hash << 5 ^ c;
                if (ptr < end && ptr - start < 64) continue;
            }
            this.add(hash, ptr - start);
        }
    }

    void hash(InputStream in, long remaining) throws IOException {
        byte[] buf = new byte[4096];
        int ptr = 0;
        int cnt = 0;
        while (0L < remaining) {
            int hash = 5381;
            int n = 0;
            do {
                int c;
                if (ptr == cnt) {
                    ptr = 0;
                    cnt = in.read(buf, 0, buf.length);
                    if (cnt <= 0) {
                        throw new EOFException();
                    }
                }
                ++n;
                if ((c = buf[ptr++] & 0xFF) == 10) break;
                hash = hash << 5 ^ c;
            } while (n < 64 && (long)n < remaining);
            this.add(hash, n);
            remaining -= (long)n;
        }
    }

    void sort() {
        Arrays.sort(this.idHash);
    }

    int score(SimilarityIndex dst, int maxScore) {
        long max = Math.max(this.fileSize, dst.fileSize);
        if (max == 0L) {
            return maxScore;
        }
        return (int)((long)(this.common(dst) * maxScore) / max);
    }

    int common(SimilarityIndex dst) {
        return SimilarityIndex.common(this, dst);
    }

    private static int common(SimilarityIndex src, SimilarityIndex dst) {
        int srcIdx = src.packedIndex(0);
        int dstIdx = dst.packedIndex(0);
        long[] srcHash = src.idHash;
        long[] dstHash = dst.idHash;
        return SimilarityIndex.common(srcHash, srcIdx, dstHash, dstIdx);
    }

    private static int common(long[] srcHash, int srcIdx, long[] dstHash, int dstIdx) {
        if (srcIdx == srcHash.length || dstIdx == dstHash.length) {
            return 0;
        }
        int common = 0;
        int srcKey = SimilarityIndex.keyOf(srcHash[srcIdx]);
        int dstKey = SimilarityIndex.keyOf(dstHash[dstIdx]);
        while (true) {
            if (srcKey == dstKey) {
                common += SimilarityIndex.countOf(dstHash[dstIdx]);
                if (++srcIdx == srcHash.length) break;
                srcKey = SimilarityIndex.keyOf(srcHash[srcIdx]);
                if (++dstIdx == dstHash.length) break;
                dstKey = SimilarityIndex.keyOf(dstHash[dstIdx]);
                continue;
            }
            if (srcKey < dstKey) {
                if (++srcIdx == srcHash.length) break;
                srcKey = SimilarityIndex.keyOf(srcHash[srcIdx]);
                continue;
            }
            if (++dstIdx == dstHash.length) break;
            dstKey = SimilarityIndex.keyOf(dstHash[dstIdx]);
        }
        return common;
    }

    int size() {
        return this.idSize;
    }

    int key(int idx) {
        return SimilarityIndex.keyOf(this.idHash[this.packedIndex(idx)]);
    }

    long count(int idx) {
        return SimilarityIndex.countOf(this.idHash[this.packedIndex(idx)]);
    }

    int findIndex(int key) {
        int i = 0;
        while (i < this.idSize) {
            if (this.key(i) == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int packedIndex(int idx) {
        return this.idHash.length - this.idSize + idx;
    }

    void add(int key, int cnt) {
        key = SimilarityIndex.hash(key);
        int j = this.slot(key);
        while (true) {
            long v;
            if ((v = this.idHash[j]) == 0L) {
                if (this.shouldGrow()) {
                    this.grow();
                    j = this.slot(key);
                    continue;
                }
                this.idHash[j] = (long)key << 46 | (long)cnt;
                ++this.idSize;
                return;
            }
            if (SimilarityIndex.keyOf(v) == key) {
                this.idHash[j] = v + (long)cnt;
                return;
            }
            if (++j < this.idHash.length) continue;
            j = 0;
        }
    }

    private static int hash(int key) {
        return (key >>> 1) % 131071;
    }

    private int slot(int key) {
        return key % this.idHash.length;
    }

    private boolean shouldGrow() {
        int n = this.idHash.length;
        return n < 131072 && n <= this.idSize * 2;
    }

    private void grow() {
        long[] oldHash = this.idHash;
        int oldSize = this.idHash.length;
        this.idHash = new long[2 * oldSize];
        int i = 0;
        while (i < oldSize) {
            long v = oldHash[i];
            if (v != 0L) {
                int j = this.slot(SimilarityIndex.keyOf(v));
                while (this.idHash[j] != 0L) {
                    if (++j < this.idHash.length) continue;
                    j = 0;
                }
                this.idHash[j] = v;
            }
            ++i;
        }
    }

    private static int keyOf(long v) {
        return (int)(v >>> 46);
    }

    private static int countOf(long v) {
        return (int)v;
    }
}

