/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.Config;

public class CoreConfig {
    public static final Config.SectionParser<CoreConfig> KEY = new Config.SectionParser<CoreConfig>(){

        @Override
        public CoreConfig parse(Config cfg) {
            return new CoreConfig(cfg, null);
        }
    };
    private final int compression;
    private final int packIndexVersion;
    private final boolean logAllRefUpdates;
    private final int streamFileThreshold;

    private CoreConfig(Config rc) {
        this.compression = rc.getInt("core", "compression", -1);
        this.packIndexVersion = rc.getInt("pack", "indexversion", 2);
        this.logAllRefUpdates = rc.getBoolean("core", "logallrefupdates", true);
        long maxMem = Runtime.getRuntime().maxMemory();
        long sft = rc.getLong("core", null, "streamfilethreshold", 0x100000L);
        sft = Math.min(sft, maxMem / 4L);
        sft = Math.min(sft, Integer.MAX_VALUE);
        this.streamFileThreshold = (int)sft;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    public boolean isLogAllRefUpdates() {
        return this.logAllRefUpdates;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    /* synthetic */ CoreConfig(Config config, CoreConfig coreConfig) {
        this(config);
    }
}

