/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Tag;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;

public abstract class ObjectInserter {
    private static final byte[] htree = Constants.encodeASCII("tree");
    private static final byte[] hparent = Constants.encodeASCII("parent");
    private static final byte[] hauthor = Constants.encodeASCII("author");
    private static final byte[] hcommitter = Constants.encodeASCII("committer");
    private static final byte[] hencoding = Constants.encodeASCII("encoding");
    private final MessageDigest digest = Constants.newMessageDigest();
    private byte[] tempBuffer;

    protected ObjectInserter() {
    }

    protected byte[] buffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new byte[8192];
        }
        return this.tempBuffer;
    }

    protected MessageDigest digest() {
        this.digest.reset();
        return this.digest;
    }

    public ObjectId idFor(int type, byte[] data) {
        return this.idFor(type, data, 0, data.length);
    }

    public ObjectId idFor(int type, byte[] data, int off, int len) {
        MessageDigest md = this.digest();
        md.update(Constants.encodedTypeString(type));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len));
        md.update((byte)0);
        md.update(data, off, len);
        return ObjectId.fromRaw(md.digest());
    }

    public ObjectId idFor(int objectType, long length, InputStream in) throws IOException {
        MessageDigest md = this.digest();
        md.update(Constants.encodedTypeString(objectType));
        md.update((byte)32);
        md.update(Constants.encodeASCII(length));
        md.update((byte)0);
        byte[] buf = this.buffer();
        while (length > 0L) {
            int n = in.read(buf, 0, (int)Math.min(length, (long)buf.length));
            if (n < 0) {
                throw new EOFException("Unexpected end of input");
            }
            md.update(buf, 0, n);
            length -= (long)n;
        }
        return ObjectId.fromRaw(md.digest());
    }

    public ObjectId insert(int type, byte[] data) throws IOException {
        return this.insert(type, data, 0, data.length);
    }

    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        return this.insert(type, len, new ByteArrayInputStream(data, off, len));
    }

    public abstract ObjectId insert(int var1, long var2, InputStream var4) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void release();

    public final byte[] format(Tree tree) throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        TreeEntry[] treeEntryArray = tree.members();
        int n = treeEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeEntry e = treeEntryArray[n2];
            ObjectId id = e.getId();
            if (id == null) {
                throw new ObjectWritingException(MessageFormat.format(JGitText.get().objectAtPathDoesNotHaveId, e.getFullName()));
            }
            e.getMode().copyTo(o);
            o.write(32);
            o.write(e.getNameUTF8());
            o.write(0);
            id.copyRawTo(o);
            ++n2;
        }
        return o.toByteArray();
    }

    public final byte[] format(Commit commit) throws UnsupportedEncodingException {
        String encoding = commit.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, encoding);
        try {
            os.write(htree);
            os.write(32);
            commit.getTreeId().copyTo(os);
            os.write(10);
            ObjectId[] ps = commit.getParentIds();
            int i = 0;
            while (i < ps.length) {
                os.write(hparent);
                os.write(32);
                ps[i].copyTo(os);
                os.write(10);
                ++i;
            }
            os.write(hauthor);
            os.write(32);
            w.write(commit.getAuthor().toExternalString());
            w.flush();
            os.write(10);
            os.write(hcommitter);
            os.write(32);
            w.write(commit.getCommitter().toExternalString());
            w.flush();
            os.write(10);
            if (!encoding.equals("UTF-8")) {
                os.write(hencoding);
                os.write(32);
                os.write(Constants.encodeASCII(encoding));
                os.write(10);
            }
            os.write(10);
            w.write(commit.getMessage());
            w.flush();
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return os.toByteArray();
    }

    public final byte[] format(Tag tag) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, Constants.CHARSET);
        try {
            w.write("object ");
            tag.getObjId().copyTo(w);
            w.write(10);
            w.write("type ");
            w.write(tag.getType());
            w.write("\n");
            w.write("tag ");
            w.write(tag.getTag());
            w.write("\n");
            w.write("tagger ");
            w.write(tag.getAuthor().toExternalString());
            w.write(10);
            w.write(10);
            w.write(tag.getMessage());
            w.close();
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return os.toByteArray();
    }

    public static class Formatter
    extends ObjectInserter {
        public ObjectId insert(int objectType, long length, InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void flush() throws IOException {
        }

        public void release() {
        }
    }
}

