/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;

public abstract class ObjectReader {
    protected static final int OBJ_ANY = -1;

    public abstract ObjectReader newReader();

    public boolean has(AnyObjectId objectId) throws IOException {
        return this.has(objectId, -1);
    }

    public boolean has(AnyObjectId objectId, int typeHint) throws IOException {
        try {
            this.open(objectId, typeHint);
            return true;
        }
        catch (MissingObjectException missingObjectException) {
            return false;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.open(objectId, -1);
    }

    public abstract ObjectLoader open(AnyObjectId var1, int var2) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.open(objectId, typeHint).getSize();
    }

    public void release() {
    }
}

