/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.EntryExistsException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.FileTreeEntry;
import org.eclipse.jgit.lib.GitlinkTreeEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymlinkTreeEntry;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.jgit.lib.TreeVisitor;
import org.eclipse.jgit.lib.Treeish;
import org.eclipse.jgit.util.RawParseUtils;

@Deprecated
public class Tree
extends TreeEntry
implements Treeish {
    private static final TreeEntry[] EMPTY_TREE = new TreeEntry[0];
    private final Repository db;
    private TreeEntry[] contents;

    public static final int compareNames(byte[] a, byte[] b, int lasta, int lastb) {
        return Tree.compareNames(a, b, 0, b.length, lasta, lastb);
    }

    private static final int compareNames(byte[] a, byte[] nameUTF8, int nameStart, int nameEnd, int lasta, int lastb) {
        int aj;
        int j = 0;
        int k = nameStart;
        while (j < a.length && k < nameEnd) {
            aj = a[j] & 0xFF;
            int bk = nameUTF8[k] & 0xFF;
            if (aj < bk) {
                return -1;
            }
            if (aj > bk) {
                return 1;
            }
            ++j;
            ++k;
        }
        if (j < a.length) {
            aj = a[j] & 0xFF;
            if (aj < lastb) {
                return -1;
            }
            if (aj > lastb) {
                return 1;
            }
            if (j == a.length - 1) {
                return 0;
            }
            return -1;
        }
        if (k < nameEnd) {
            int bk = nameUTF8[k] & 0xFF;
            if (lasta < bk) {
                return -1;
            }
            if (lasta > bk) {
                return 1;
            }
            if (k == nameEnd - 1) {
                return 0;
            }
            return 1;
        }
        if (lasta < lastb) {
            return -1;
        }
        if (lasta > lastb) {
            return 1;
        }
        int namelength = nameEnd - nameStart;
        if (a.length == namelength) {
            return 0;
        }
        if (a.length < namelength) {
            return -1;
        }
        return 1;
    }

    private static final byte[] substring(byte[] s, int nameStart, int nameEnd) {
        if (nameStart == 0 && nameStart == s.length) {
            return s;
        }
        byte[] n = new byte[nameEnd - nameStart];
        System.arraycopy(s, nameStart, n, 0, n.length);
        return n;
    }

    private static final int binarySearch(TreeEntry[] entries, byte[] nameUTF8, int nameUTF8last, int nameStart, int nameEnd) {
        if (entries.length == 0) {
            return -1;
        }
        int high = entries.length;
        int low = 0;
        do {
            int mid;
            int cmp;
            if ((cmp = Tree.compareNames(entries[mid = low + high >>> 1].getNameUTF8(), nameUTF8, nameStart, nameEnd, TreeEntry.lastChar(entries[mid]), nameUTF8last)) < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            high = mid;
        } while (low < high);
        return -(low + 1);
    }

    public Tree(Repository repo) {
        super(null, null, null);
        this.db = repo;
        this.contents = EMPTY_TREE;
    }

    public Tree(Repository repo, ObjectId myId, byte[] raw) throws IOException {
        super(null, myId, null);
        this.db = repo;
        this.readTree(raw);
    }

    public Tree(Tree parent, byte[] nameUTF8) {
        super(parent, null, nameUTF8);
        this.db = parent.getRepository();
        this.contents = EMPTY_TREE;
    }

    public Tree(Tree parent, ObjectId id, byte[] nameUTF8) {
        super(parent, id, nameUTF8);
        this.db = parent.getRepository();
    }

    public FileMode getMode() {
        return FileMode.TREE;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Repository getRepository() {
        return this.db;
    }

    public final ObjectId getTreeId() {
        return this.getId();
    }

    public final Tree getTree() {
        return this;
    }

    public boolean isLoaded() {
        return this.contents != null;
    }

    public void unload() {
        if (this.isModified()) {
            throw new IllegalStateException(JGitText.get().cannotUnloadAModifiedTree);
        }
        this.contents = null;
    }

    public FileTreeEntry addFile(String name) throws IOException {
        return this.addFile(Repository.gitInternalSlash(Constants.encode(name)), 0);
    }

    public FileTreeEntry addFile(byte[] s, int offset) throws IOException {
        int slash = offset;
        while (slash < s.length && s[slash] != 47) {
            ++slash;
        }
        this.ensureLoaded();
        int xlast = slash < s.length ? 47 : 0;
        int p = Tree.binarySearch(this.contents, s, xlast, offset, slash);
        if (p >= 0 && slash < s.length && this.contents[p] instanceof Tree) {
            return ((Tree)this.contents[p]).addFile(s, slash + 1);
        }
        byte[] newName = Tree.substring(s, offset, slash);
        if (p >= 0) {
            throw new EntryExistsException(RawParseUtils.decode(newName));
        }
        if (slash < s.length) {
            Tree t = new Tree(this, newName);
            this.insertEntry(p, t);
            return t.addFile(s, slash + 1);
        }
        FileTreeEntry f = new FileTreeEntry(this, null, newName, false);
        this.insertEntry(p, f);
        return f;
    }

    public Tree addTree(String name) throws IOException {
        return this.addTree(Repository.gitInternalSlash(Constants.encode(name)), 0);
    }

    public Tree addTree(byte[] s, int offset) throws IOException {
        int slash = offset;
        while (slash < s.length && s[slash] != 47) {
            ++slash;
        }
        this.ensureLoaded();
        int p = Tree.binarySearch(this.contents, s, 47, offset, slash);
        if (p >= 0 && slash < s.length && this.contents[p] instanceof Tree) {
            return ((Tree)this.contents[p]).addTree(s, slash + 1);
        }
        byte[] newName = Tree.substring(s, offset, slash);
        if (p >= 0) {
            throw new EntryExistsException(RawParseUtils.decode(newName));
        }
        Tree t = new Tree(this, newName);
        this.insertEntry(p, t);
        return slash == s.length ? t : t.addTree(s, slash + 1);
    }

    public void addEntry(TreeEntry e) throws IOException {
        this.ensureLoaded();
        int p = Tree.binarySearch(this.contents, e.getNameUTF8(), TreeEntry.lastChar(e), 0, e.getNameUTF8().length);
        if (p >= 0) {
            throw new EntryExistsException(e.getName());
        }
        e.attachParent(this);
        this.insertEntry(p, e);
    }

    private void insertEntry(int p, TreeEntry e) {
        TreeEntry[] c = this.contents;
        TreeEntry[] n = new TreeEntry[c.length + 1];
        p = -(p + 1);
        int k = c.length - 1;
        while (k >= p) {
            n[k + 1] = c[k];
            --k;
        }
        n[p] = e;
        k = p - 1;
        while (k >= 0) {
            n[k] = c[k];
            --k;
        }
        this.contents = n;
        this.setModified();
    }

    void removeEntry(TreeEntry e) {
        TreeEntry[] c = this.contents;
        int p = Tree.binarySearch(c, e.getNameUTF8(), TreeEntry.lastChar(e), 0, e.getNameUTF8().length);
        if (p >= 0) {
            TreeEntry[] n = new TreeEntry[c.length - 1];
            int k = c.length - 1;
            while (k > p) {
                n[k - 1] = c[k];
                --k;
            }
            k = p - 1;
            while (k >= 0) {
                n[k] = c[k];
                --k;
            }
            this.contents = n;
            this.setModified();
        }
    }

    public int memberCount() throws IOException {
        this.ensureLoaded();
        return this.contents.length;
    }

    public TreeEntry[] members() throws IOException {
        this.ensureLoaded();
        TreeEntry[] c = this.contents;
        if (c.length != 0) {
            TreeEntry[] r = new TreeEntry[c.length];
            int k = c.length - 1;
            while (k >= 0) {
                r[k] = c[k];
                --k;
            }
            return r;
        }
        return c;
    }

    private boolean exists(String s, byte slast) throws IOException {
        return this.findMember(s, slast) != null;
    }

    public boolean existsTree(String path) throws IOException {
        return this.exists(path, (byte)47);
    }

    public boolean existsBlob(String path) throws IOException {
        return this.exists(path, (byte)0);
    }

    private TreeEntry findMember(String s, byte slast) throws IOException {
        return this.findMember(Repository.gitInternalSlash(Constants.encode(s)), slast, 0);
    }

    private TreeEntry findMember(byte[] s, byte slast, int offset) throws IOException {
        int slash = offset;
        while (slash < s.length && s[slash] != 47) {
            ++slash;
        }
        this.ensureLoaded();
        int xlast = slash < s.length ? 47 : (int)slast;
        int p = Tree.binarySearch(this.contents, s, xlast, offset, slash);
        if (p >= 0) {
            TreeEntry r = this.contents[p];
            if (slash < s.length - 1) {
                return r instanceof Tree ? ((Tree)r).findMember(s, slast, slash + 1) : null;
            }
            return r;
        }
        return null;
    }

    public TreeEntry findBlobMember(String s) throws IOException {
        return this.findMember(s, (byte)0);
    }

    public TreeEntry findTreeMember(String s) throws IOException {
        return this.findMember(s, (byte)47);
    }

    public void accept(TreeVisitor tv, int flags) throws IOException {
        if ((1 & flags) == 1 && !this.isModified()) {
            return;
        }
        if ((2 & flags) == 2 && !this.isLoaded()) {
            tv.startVisitTree(this);
            tv.endVisitTree(this);
            return;
        }
        this.ensureLoaded();
        tv.startVisitTree(this);
        TreeEntry[] c = (4 & flags) == 4 ? this.members() : this.contents;
        int k = 0;
        while (k < c.length) {
            c[k].accept(tv, flags);
            ++k;
        }
        tv.endVisitTree(this);
    }

    private void ensureLoaded() throws IOException, MissingObjectException {
        if (!this.isLoaded()) {
            ObjectLoader ldr = this.db.open(this.getId(), 2);
            this.readTree(ldr.getCachedBytes());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readTree(byte[] raw) throws IOException {
        rawSize = raw.length;
        rawPtr = 0;
        nextIndex = 0;
        ** GOTO lbl11
        {
            ++rawPtr;
            do {
                if (rawPtr < rawSize && raw[rawPtr] != 0) continue block0;
                ++rawPtr;
                rawPtr += 20;
                ++nextIndex;
lbl11:
                // 2 sources

            } while (rawPtr < rawSize);
        }
        temp = new TreeEntry[nextIndex];
        rawPtr = 0;
        nextIndex = 0;
        while (rawPtr < rawSize) {
            if ((c = raw[rawPtr++]) < 48 || c > 55) {
                throw new CorruptObjectException(this.getId(), JGitText.get().corruptObjectInvalidEntryMode);
            }
            mode = c - 48;
            while (32 != (c = raw[rawPtr++])) {
                if (c < 48 || c > 55) {
                    throw new CorruptObjectException(this.getId(), JGitText.get().corruptObjectInvalidMode);
                }
                mode <<= 3;
                mode += c - 48;
            }
            nameLen = 0;
            while (raw[rawPtr + nameLen] != 0) {
                ++nameLen;
            }
            name = new byte[nameLen];
            System.arraycopy(raw, rawPtr, name, 0, nameLen);
            id = ObjectId.fromRaw(raw, rawPtr += nameLen + 1);
            rawPtr += 20;
            if (FileMode.REGULAR_FILE.equals(mode)) {
                ent /* !! */  = new FileTreeEntry(this, id, name, false);
            } else if (FileMode.EXECUTABLE_FILE.equals(mode)) {
                ent /* !! */  = new FileTreeEntry(this, id, name, true);
            } else if (FileMode.TREE.equals(mode)) {
                ent /* !! */  = new Tree(this, id, name);
            } else if (FileMode.SYMLINK.equals(mode)) {
                ent /* !! */  = new SymlinkTreeEntry(this, id, name);
            } else if (FileMode.GITLINK.equals(mode)) {
                ent /* !! */  = new GitlinkTreeEntry(this, id, name);
            } else {
                throw new CorruptObjectException(this.getId(), MessageFormat.format(JGitText.get().corruptObjectInvalidMode2, new Object[]{Integer.toOctalString(mode)}));
            }
            temp[nextIndex++] = ent /* !! */ ;
        }
        this.contents = temp;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append(ObjectId.toString(this.getId()));
        r.append(" T ");
        r.append(this.getFullName());
        return r.toString();
    }
}

