/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeFormatter {
    public void formatMerge(OutputStream out, MergeResult res, List<String> seqName, String charsetName) throws IOException {
        String lastConflictingName = null;
        boolean threeWayMerge = res.getSequences().size() == 3;
        for (MergeChunk chunk : res) {
            RawText seq = (RawText)res.getSequences().get(chunk.getSequenceIndex());
            if (lastConflictingName != null && chunk.getConflictState() != MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
                out.write((">>>>>>> " + lastConflictingName + "\n").getBytes(charsetName));
                lastConflictingName = null;
            }
            if (chunk.getConflictState() == MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE) {
                out.write(("<<<<<<< " + seqName.get(chunk.getSequenceIndex()) + "\n").getBytes(charsetName));
                lastConflictingName = seqName.get(chunk.getSequenceIndex());
            } else if (chunk.getConflictState() == MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE) {
                lastConflictingName = seqName.get(chunk.getSequenceIndex());
                out.write((threeWayMerge ? "=======\n" : "======= " + lastConflictingName + "\n").getBytes(charsetName));
            }
            int i = chunk.getBegin();
            while (i < chunk.getEnd()) {
                seq.writeLine(out, i);
                out.write(10);
                ++i;
            }
        }
        if (lastConflictingName != null) {
            out.write((">>>>>>> " + lastConflictingName + "\n").getBytes(charsetName));
        }
    }

    public void formatMerge(OutputStream out, MergeResult res, String baseName, String oursName, String theirsName, String charsetName) throws IOException {
        ArrayList<String> names = new ArrayList<String>(3);
        names.add(baseName);
        names.add(oursName);
        names.add(theirsName);
        this.formatMerge(out, res, names, charsetName);
    }
}

