/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

class RewriteTreeFilter
extends RevFilter {
    private static final int PARSED = 1;
    private static final int UNINTERESTING = 4;
    private static final int REWRITE = 8;
    private final TreeWalk pathFilter;
    private final Repository repository;

    RewriteTreeFilter(RevWalk walker, TreeFilter t) {
        this.repository = walker.repository;
        this.pathFilter = new TreeWalk(walker.reader);
        this.pathFilter.setFilter(t);
        this.pathFilter.setRecursive(t.shouldBeRecursive());
    }

    public RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    public boolean include(RevWalk walker, RevCommit c) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        pList = c.parents;
        nParents = pList.length;
        tw = this.pathFilter;
        trees = new ObjectId[nParents + 1];
        i = 0;
        while (i < nParents) {
            p = c.parents[i];
            if ((p.flags & 1) == 0) {
                p.parseHeaders(walker);
            }
            trees[i] = p.getTree();
            ++i;
        }
        trees[nParents] = c.getTree();
        tw.reset(trees);
        if (nParents == 1) {
            chgs = 0;
            adds = 0;
            while (tw.next()) {
                ++chgs;
                if (tw.getRawMode(0) != 0 || tw.getRawMode(1) == 0) break;
                ++adds;
            }
            if (chgs == 0) {
                c.flags |= 8;
                return false;
            }
            if (adds > 0 && tw.getFilter() instanceof FollowFilter) {
                this.updateFollowFilter((ObjectId[])trees);
            }
            return true;
        }
        if (nParents == 0) {
            if (tw.next()) {
                return true;
            }
            c.flags |= 8;
            return false;
        }
        chgs = new int[nParents];
        adds = new int[nParents];
        while (tw.next()) {
            myMode = tw.getRawMode(nParents);
            i = 0;
            while (i < nParents) {
                pMode = tw.getRawMode(i);
                if (myMode != pMode || !tw.idEqual(i, nParents)) {
                    v0 = i;
                    chgs[v0] = chgs[v0] + 1;
                    if (pMode == 0 && myMode != 0) {
                        v1 = i;
                        adds[v1] = adds[v1] + 1;
                    }
                }
                ++i;
            }
        }
        same = false;
        diff = false;
        i = 0;
        while (i < nParents) {
            if (chgs[i] != 0) ** GOTO lbl62
            p = pList[i];
            if ((p.flags & 4) != 0) {
                same = true;
            } else {
                c.flags |= 8;
                c.parents = new RevCommit[]{p};
                return false;
lbl62:
                // 1 sources

                if (chgs[i] == adds[i]) {
                    pList[i].parents = RevCommit.NO_PARENTS;
                }
                diff = true;
            }
            ++i;
        }
        if (diff && !same) {
            return true;
        }
        c.flags |= 8;
        return false;
    }

    private void updateFollowFilter(ObjectId[] trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk tw = this.pathFilter;
        FollowFilter oldFilter = (FollowFilter)tw.getFilter();
        tw.setFilter(TreeFilter.ANY_DIFF);
        tw.reset(trees);
        List<DiffEntry> files = DiffEntry.scan(tw);
        RenameDetector rd = new RenameDetector(this.repository);
        rd.addAll(files);
        files = rd.compute();
        FollowFilter newFilter = oldFilter;
        for (DiffEntry ent : files) {
            if (!RewriteTreeFilter.isRename(ent) || !ent.getNewName().equals(oldFilter.getPath())) continue;
            newFilter = FollowFilter.create(ent.getOldName());
            break;
        }
        tw.setFilter(newFilter);
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }
}

