/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.NotRevFilter;

public abstract class RevFilter {
    public static final RevFilter ALL = new RevFilter(){

        public boolean include(RevWalk walker, RevCommit c) {
            return true;
        }

        public RevFilter clone() {
            return this;
        }

        public String toString() {
            return "ALL";
        }
    };
    public static final RevFilter NONE = new RevFilter(){

        public boolean include(RevWalk walker, RevCommit c) {
            return false;
        }

        public RevFilter clone() {
            return this;
        }

        public String toString() {
            return "NONE";
        }
    };
    public static final RevFilter NO_MERGES = new RevFilter(){

        public boolean include(RevWalk walker, RevCommit c) {
            return c.getParentCount() < 2;
        }

        public RevFilter clone() {
            return this;
        }

        public String toString() {
            return "NO_MERGES";
        }
    };
    public static final RevFilter MERGE_BASE = new RevFilter(){

        public boolean include(RevWalk walker, RevCommit c) {
            throw new UnsupportedOperationException(JGitText.get().cannotBeCombined);
        }

        public RevFilter clone() {
            return this;
        }

        public String toString() {
            return "MERGE_BASE";
        }
    };

    public RevFilter negate() {
        return NotRevFilter.create(this);
    }

    public abstract boolean include(RevWalk var1, RevCommit var2) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract RevFilter clone();

    public String toString() {
        String n = this.getClass().getName();
        int lastDot = n.lastIndexOf(46);
        if (lastDot >= 0) {
            n = n.substring(lastDot + 1);
        }
        return n.replace('$', '.');
    }
}

