/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.ObjectDirectory;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;

class CachedObjectDirectory
extends FileObjectDatabase {
    private final ObjectIdSubclassMap<ObjectId> unpackedObjects = new ObjectIdSubclassMap();
    private final ObjectDirectory wrapped;
    private FileObjectDatabase.AlternateHandle[] alts;

    CachedObjectDirectory(ObjectDirectory wrapped) {
        this.wrapped = wrapped;
        File objects = wrapped.getDirectory();
        String[] fanout = objects.list();
        if (fanout == null) {
            fanout = new String[]{};
        }
        String[] stringArray = fanout;
        int n = fanout.length;
        int n2 = 0;
        while (n2 < n) {
            String[] entries;
            String d = stringArray[n2];
            if (d.length() == 2 && (entries = new File(objects, d).list()) != null) {
                String[] stringArray2 = entries;
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    String e = stringArray2[n4];
                    if (e.length() == 38) {
                        try {
                            this.unpackedObjects.add(ObjectId.fromString(String.valueOf(d) + e));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void close() {
    }

    public ObjectInserter newInserter() {
        return this.wrapped.newInserter();
    }

    public ObjectDatabase newCachedDatabase() {
        return this;
    }

    FileObjectDatabase newCachedFileObjectDatabase() {
        return this;
    }

    File getDirectory() {
        return this.wrapped.getDirectory();
    }

    FileObjectDatabase.AlternateHandle[] myAlternates() {
        if (this.alts == null) {
            FileObjectDatabase.AlternateHandle[] src = this.wrapped.myAlternates();
            this.alts = new FileObjectDatabase.AlternateHandle[src.length];
            int i = 0;
            while (i < this.alts.length) {
                FileObjectDatabase s = src[i].db;
                this.alts[i] = new FileObjectDatabase.AlternateHandle(s.newCachedFileObjectDatabase());
                ++i;
            }
        }
        return this.alts;
    }

    boolean tryAgain1() {
        return this.wrapped.tryAgain1();
    }

    public boolean has(AnyObjectId objectId) {
        return this.hasObjectImpl1(objectId);
    }

    boolean hasObject1(AnyObjectId objectId) {
        return this.unpackedObjects.contains(objectId) || this.wrapped.hasObject1(objectId);
    }

    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        return this.openObjectImpl1(curs, objectId);
    }

    ObjectLoader openObject1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return this.wrapped.openObject2(curs, objectId.name(), objectId);
        }
        return this.wrapped.openObject1(curs, objectId);
    }

    boolean hasObject2(String objectId) {
        throw new UnsupportedOperationException();
    }

    ObjectLoader openObject2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        throw new UnsupportedOperationException();
    }

    long getObjectSize1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        if (this.unpackedObjects.contains(objectId)) {
            return this.wrapped.getObjectSize2(curs, objectId.name(), objectId);
        }
        return this.wrapped.getObjectSize1(curs, objectId);
    }

    long getObjectSize2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        throw new UnsupportedOperationException();
    }

    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        this.wrapped.selectObjectRepresentation(packer, otp, curs);
    }

    int getStreamFileThreshold() {
        return this.wrapped.getStreamFileThreshold();
    }
}

