/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;

abstract class FileObjectDatabase
extends ObjectDatabase {
    FileObjectDatabase() {
    }

    public ObjectReader newReader() {
        return new WindowCursor(this);
    }

    public boolean has(AnyObjectId objectId) {
        return this.hasObjectImpl1(objectId) || this.hasObjectImpl2(objectId.name());
    }

    final boolean hasObjectImpl1(AnyObjectId objectId) {
        if (this.hasObject1(objectId)) {
            return true;
        }
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (alt.db.hasObjectImpl1(objectId)) {
                return true;
            }
            ++n2;
        }
        return this.tryAgain1() && this.hasObject1(objectId);
    }

    final boolean hasObjectImpl2(String objectId) {
        if (this.hasObject2(objectId)) {
            return true;
        }
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (alt.db.hasObjectImpl2(objectId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObjectImpl1(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        ldr = this.openObjectImpl2(curs, objectId.name(), objectId);
        if (ldr != null) {
            return ldr;
        }
        return null;
    }

    final ObjectLoader openObjectImpl1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObject1(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            ldr = alt.db.openObjectImpl1(curs, objectId);
            if (ldr != null) {
                return ldr;
            }
            ++n2;
        }
        if (this.tryAgain1() && (ldr = this.openObject1(curs, objectId)) != null) {
            return ldr;
        }
        return null;
    }

    final ObjectLoader openObjectImpl2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObject2(curs, objectName, objectId);
        if (ldr != null) {
            return ldr;
        }
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            ldr = alt.db.openObjectImpl2(curs, objectName, objectId);
            if (ldr != null) {
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    long getObjectSize(WindowCursor curs, AnyObjectId objectId) throws IOException {
        long sz = this.getObjectSizeImpl1(curs, objectId);
        if (0L <= sz) {
            return sz;
        }
        return this.getObjectSizeImpl2(curs, objectId.name(), objectId);
    }

    final long getObjectSizeImpl1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        long sz = this.getObjectSize1(curs, objectId);
        if (0L <= sz) {
            return sz;
        }
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            sz = alt.db.getObjectSizeImpl1(curs, objectId);
            if (0L <= sz) {
                return sz;
            }
            ++n2;
        }
        if (this.tryAgain1() && 0L <= (sz = this.getObjectSize1(curs, objectId))) {
            return sz;
        }
        return -1L;
    }

    final long getObjectSizeImpl2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        long sz = this.getObjectSize2(curs, objectName, objectId);
        if (0L <= sz) {
            return sz;
        }
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            sz = alt.db.getObjectSizeImpl2(curs, objectName, objectId);
            if (0L <= sz) {
                return sz;
            }
            ++n2;
        }
        return -1L;
    }

    abstract void selectObjectRepresentation(PackWriter var1, ObjectToPack var2, WindowCursor var3) throws IOException;

    abstract File getDirectory();

    abstract AlternateHandle[] myAlternates();

    abstract boolean tryAgain1();

    abstract boolean hasObject1(AnyObjectId var1);

    abstract boolean hasObject2(String var1);

    abstract ObjectLoader openObject1(WindowCursor var1, AnyObjectId var2) throws IOException;

    abstract ObjectLoader openObject2(WindowCursor var1, String var2, AnyObjectId var3) throws IOException;

    abstract long getObjectSize1(WindowCursor var1, AnyObjectId var2) throws IOException;

    abstract long getObjectSize2(WindowCursor var1, String var2, AnyObjectId var3) throws IOException;

    abstract FileObjectDatabase newCachedFileObjectDatabase();

    abstract int getStreamFileThreshold();

    static class AlternateHandle {
        final FileObjectDatabase db;

        AlternateHandle(FileObjectDatabase db) {
            this.db = db;
        }

        void close() {
            this.db.close();
        }
    }

    static class AlternateRepository
    extends AlternateHandle {
        final FileRepository repository;

        AlternateRepository(FileRepository r) {
            super(r.getObjectDatabase());
            this.repository = r;
        }

        void close() {
            this.repository.close();
        }
    }
}

