/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.CachedObjectDirectory;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.LocalObjectRepresentation;
import org.eclipse.jgit.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.UnpackedObject;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDirectory
extends FileObjectDatabase
implements ConfigChangedListener {
    private static final PackList NO_PACKS = new PackList(-1L, -1L, new PackFile[0]);
    private final Config config;
    private final File objects;
    private final File infoDirectory;
    private final File packDirectory;
    private final File alternatesFile;
    private final AtomicReference<PackList> packList;
    private final FS fs;
    private final AtomicReference<FileObjectDatabase.AlternateHandle[]> alternates;
    private int streamFileThreshold;

    public ObjectDirectory(Config cfg, File dir, File[] alternatePaths, FS fs) throws IOException {
        this.config = cfg;
        this.objects = dir;
        this.infoDirectory = new File(this.objects, "info");
        this.packDirectory = new File(this.objects, "pack");
        this.alternatesFile = new File(this.infoDirectory, "alternates");
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.fs = fs;
        this.alternates = new AtomicReference();
        if (alternatePaths != null) {
            FileObjectDatabase.AlternateHandle[] alt = new FileObjectDatabase.AlternateHandle[alternatePaths.length];
            int i = 0;
            while (i < alternatePaths.length) {
                alt[i] = this.openAlternate(alternatePaths[i]);
                ++i;
            }
            this.alternates.set(alt);
        }
        this.onConfigChanged(new ConfigChangedEvent());
    }

    @Override
    public void onConfigChanged(ConfigChangedEvent event) {
        CoreConfig core = this.config.get(CoreConfig.KEY);
        this.streamFileThreshold = core.getStreamFileThreshold();
    }

    @Override
    public final File getDirectory() {
        return this.objects;
    }

    @Override
    public boolean exists() {
        return this.objects.exists();
    }

    @Override
    public void create() throws IOException {
        this.objects.mkdirs();
        this.infoDirectory.mkdir();
        this.packDirectory.mkdir();
    }

    @Override
    public ObjectInserter newInserter() {
        return new ObjectDirectoryInserter(this, this.config);
    }

    @Override
    public void close() {
        PackList packs = this.packList.get();
        this.packList.set(NO_PACKS);
        PackFile[] packFileArray = packs.packs;
        int n = packs.packs.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile p = packFileArray[n2];
            p.close();
            ++n2;
        }
        FileObjectDatabase.AlternateHandle[] alt = this.alternates.get();
        if (alt != null) {
            this.alternates.set(null);
            FileObjectDatabase.AlternateHandle[] alternateHandleArray = alt;
            int n3 = alt.length;
            n = 0;
            while (n < n3) {
                FileObjectDatabase.AlternateHandle od = alternateHandleArray[n];
                od.close();
                ++n;
            }
        }
    }

    public File fileFor(AnyObjectId objectId) {
        return this.fileFor(objectId.name());
    }

    private File fileFor(String objectName) {
        String d = objectName.substring(0, 2);
        String f = objectName.substring(2);
        return new File(new File(this.objects, d), f);
    }

    public Collection<PackFile> getPacks() {
        PackFile[] packs = this.packList.get().packs;
        return Collections.unmodifiableCollection(Arrays.asList(packs));
    }

    public void openPack(File pack, File idx) throws IOException {
        String p = pack.getName();
        String i = idx.getName();
        if (p.length() != 50 || !p.startsWith("pack-") || !p.endsWith(".pack")) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, pack));
        }
        if (i.length() != 49 || !i.startsWith("pack-") || !i.endsWith(".idx")) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, idx));
        }
        if (!p.substring(0, 45).equals(i.substring(0, 45))) {
            throw new IOException(MessageFormat.format(JGitText.get().packDoesNotMatchIndex, pack));
        }
        this.insertPack(new PackFile(idx, pack));
    }

    public String toString() {
        return "ObjectDirectory[" + this.getDirectory() + "]";
    }

    @Override
    boolean hasObject1(AnyObjectId objectId) {
        PackFile[] packFileArray = this.packList.get().packs;
        int n = this.packList.get().packs.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile p = packFileArray[n2];
            try {
                if (p.hasObject(objectId)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                this.removePack(p);
            }
            ++n2;
        }
        return false;
    }

    @Override
    ObjectLoader openObject1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        PackList pList = this.packList.get();
        block3: while (true) {
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    ObjectLoader ldr = p.get(curs, objectId);
                    if (ldr != null) {
                        return ldr;
                    }
                }
                catch (PackMismatchException packMismatchException) {
                    pList = this.scanPacks(pList);
                    continue block3;
                }
                catch (IOException iOException) {
                    this.removePack(p);
                }
                ++n2;
            }
            break;
        }
        return null;
    }

    @Override
    long getObjectSize1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        PackList pList = this.packList.get();
        block3: while (true) {
            PackFile[] packFileArray = pList.packs;
            int n = pList.packs.length;
            int n2 = 0;
            while (n2 < n) {
                PackFile p = packFileArray[n2];
                try {
                    long sz = p.getObjectSize(curs, objectId);
                    if (0L <= sz) {
                        return sz;
                    }
                }
                catch (PackMismatchException packMismatchException) {
                    pList = this.scanPacks(pList);
                    continue block3;
                }
                catch (IOException iOException) {
                    this.removePack(p);
                }
                ++n2;
            }
            break;
        }
        return -1L;
    }

    @Override
    long getObjectSize2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        long l;
        File path = this.fileFor(objectName);
        FileInputStream in = new FileInputStream(path);
        try {
            l = UnpackedObject.getSize(in, objectId, curs);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return -1L;
            }
        }
        in.close();
        return l;
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        PackList pList = this.packList.get();
        block3: while (true) {
            objectArray = pList.packs;
            n2 = pList.packs.length;
            n = 0;
            while (n < n2) {
                PackFile p = objectArray[n];
                try {
                    LocalObjectRepresentation rep = p.representation(curs, otp);
                    if (rep != null) {
                        packer.select(otp, rep);
                    }
                }
                catch (PackMismatchException packMismatchException) {
                    pList = this.scanPacks(pList);
                    continue block3;
                }
                catch (IOException iOException) {
                    this.removePack(p);
                }
                ++n;
            }
            break;
        }
        objectArray = this.myAlternates();
        n2 = objectArray.length;
        n = 0;
        while (n < n2) {
            Object h = objectArray[n];
            ((FileObjectDatabase.AlternateHandle)h).db.selectObjectRepresentation(packer, otp, curs);
            ++n;
        }
    }

    @Override
    boolean hasObject2(String objectName) {
        return this.fileFor(objectName).exists();
    }

    @Override
    ObjectLoader openObject2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        ObjectLoader objectLoader;
        File path = this.fileFor(objectName);
        FileInputStream in = new FileInputStream(path);
        try {
            objectLoader = UnpackedObject.open(in, path, objectId, curs);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        in.close();
        return objectLoader;
    }

    @Override
    boolean tryAgain1() {
        PackList old = this.packList.get();
        if (old.tryAgain(this.packDirectory.lastModified())) {
            return old != this.scanPacks(old);
        }
        return false;
    }

    private void insertPack(PackFile pf) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            String name = pf.getPackFile().getName();
            PackFile[] packFileArray = oldList;
            int n2 = oldList.length;
            int n3 = 0;
            while (n3 < n2) {
                PackFile p = packFileArray[n3];
                if (PackFile.SORT.compare(pf, p) < 0) break;
                if (name.equals(p.getPackFile().getName())) {
                    return;
                }
                ++n3;
            }
            newList = new PackFile[1 + oldList.length];
            newList[0] = pf;
            System.arraycopy(oldList, 0, newList, 1, oldList.length);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.lastRead, o.lastModified, newList)));
    }

    private void removePack(PackFile deadPack) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            int j = ObjectDirectory.indexOf(oldList, deadPack);
            if (j < 0) break;
            newList = new PackFile[oldList.length - 1];
            System.arraycopy(oldList, 0, newList, 0, j);
            System.arraycopy(oldList, j + 1, newList, j, newList.length - j);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.lastRead, o.lastModified, newList)));
        deadPack.close();
    }

    private static int indexOf(PackFile[] list, PackFile pack) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == pack) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackList scanPacks(PackList original) {
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList n;
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
            return n;
        }
    }

    private PackList scanPacksImpl(PackList old) {
        Map<String, PackFile> forReuse = ObjectDirectory.reuseMap(old);
        long lastRead = System.currentTimeMillis();
        long lastModified = this.packDirectory.lastModified();
        Set<String> names = this.listPackDirectory();
        ArrayList<PackFile> list = new ArrayList<PackFile>(names.size() >> 2);
        boolean foundNew = false;
        for (String indexName : names) {
            String base;
            String packName;
            if (indexName.length() != 49 || !indexName.endsWith(".idx") || !names.contains(packName = String.valueOf(base = indexName.substring(0, indexName.length() - 4)) + ".pack")) continue;
            PackFile oldPack = forReuse.remove(packName);
            if (oldPack != null) {
                list.add(oldPack);
                continue;
            }
            File packFile = new File(this.packDirectory, packName);
            File idxFile = new File(this.packDirectory, indexName);
            list.add(new PackFile(idxFile, packFile));
            foundNew = true;
        }
        if (!foundNew && lastModified == old.lastModified && forReuse.isEmpty()) {
            return old.updateLastRead(lastRead);
        }
        for (PackFile p : forReuse.values()) {
            p.close();
        }
        if (list.isEmpty()) {
            return new PackList(lastRead, lastModified, ObjectDirectory.NO_PACKS.packs);
        }
        PackFile[] r = list.toArray(new PackFile[list.size()]);
        Arrays.sort(r, PackFile.SORT);
        return new PackList(lastRead, lastModified, r);
    }

    private static Map<String, PackFile> reuseMap(PackList old) {
        HashMap<String, PackFile> forReuse = new HashMap<String, PackFile>();
        PackFile[] packFileArray = old.packs;
        int n = old.packs.length;
        int n2 = 0;
        while (n2 < n) {
            PackFile p = packFileArray[n2];
            if (p.invalid()) {
                p.close();
            } else {
                PackFile prior = forReuse.put(p.getPackFile().getName(), p);
                if (prior != null) {
                    forReuse.put(prior.getPackFile().getName(), prior);
                    p.close();
                }
            }
            ++n2;
        }
        return forReuse;
    }

    private Set<String> listPackDirectory() {
        String[] nameList = this.packDirectory.list();
        if (nameList == null) {
            return Collections.emptySet();
        }
        HashSet<String> nameSet = new HashSet<String>(nameList.length << 1);
        String[] stringArray = nameList;
        int n = nameList.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.startsWith("pack-")) {
                nameSet.add(name);
            }
            ++n2;
        }
        return nameSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    FileObjectDatabase.AlternateHandle[] myAlternates() {
        FileObjectDatabase.AlternateHandle[] alt = this.alternates.get();
        if (alt == null) {
            AtomicReference<FileObjectDatabase.AlternateHandle[]> atomicReference = this.alternates;
            synchronized (atomicReference) {
                alt = this.alternates.get();
                if (alt == null) {
                    try {
                        alt = this.loadAlternates();
                    }
                    catch (IOException iOException) {
                        alt = new FileObjectDatabase.AlternateHandle[]{};
                    }
                    this.alternates.set(alt);
                }
            }
        }
        return alt;
    }

    private FileObjectDatabase.AlternateHandle[] loadAlternates() throws IOException {
        ArrayList<FileObjectDatabase.AlternateHandle> l = new ArrayList<FileObjectDatabase.AlternateHandle>(4);
        BufferedReader br = ObjectDirectory.open(this.alternatesFile);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                l.add(this.openAlternate(line));
            }
        }
        finally {
            br.close();
        }
        return l.toArray(new FileObjectDatabase.AlternateHandle[l.size()]);
    }

    private static BufferedReader open(File f) throws FileNotFoundException {
        return new BufferedReader(new FileReader(f));
    }

    private FileObjectDatabase.AlternateHandle openAlternate(String location) throws IOException {
        File objdir = this.fs.resolve(this.objects, location);
        return this.openAlternate(objdir);
    }

    private FileObjectDatabase.AlternateHandle openAlternate(File objdir) throws IOException {
        File parent = objdir.getParentFile();
        if (RepositoryCache.FileKey.isGitRepository(parent, this.fs)) {
            RepositoryCache.FileKey key = RepositoryCache.FileKey.exact(parent, this.fs);
            FileRepository db = (FileRepository)RepositoryCache.open(key);
            return new FileObjectDatabase.AlternateRepository(db);
        }
        ObjectDirectory db = new ObjectDirectory(this.config, objdir, null, this.fs);
        return new FileObjectDatabase.AlternateHandle(db);
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this.newCachedFileObjectDatabase();
    }

    @Override
    FileObjectDatabase newCachedFileObjectDatabase() {
        return new CachedObjectDirectory(this);
    }

    @Override
    int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    private static final class PackList {
        volatile long lastRead;
        final long lastModified;
        final PackFile[] packs;
        private boolean cannotBeRacilyClean;

        PackList(long lastRead, long lastModified, PackFile[] packs) {
            this.lastRead = lastRead;
            this.lastModified = lastModified;
            this.packs = packs;
            this.cannotBeRacilyClean = this.notRacyClean(lastRead);
        }

        private boolean notRacyClean(long read) {
            return read - this.lastModified > 120000L;
        }

        PackList updateLastRead(long now) {
            if (this.notRacyClean(now)) {
                this.cannotBeRacilyClean = true;
            }
            this.lastRead = now;
            return this;
        }

        boolean tryAgain(long currLastModified) {
            if (this.lastModified != currLastModified) {
                return true;
            }
            if (this.cannotBeRacilyClean) {
                return false;
            }
            return !this.notRacyClean(this.lastRead);
        }
    }
}

