/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.storage.file.ObjectDirectory;

class ObjectDirectoryInserter
extends ObjectInserter {
    private final ObjectDirectory db;
    private final Config config;
    private Deflater deflate;

    ObjectDirectoryInserter(ObjectDirectory dest, Config cfg) {
        this.db = dest;
        this.config = cfg;
    }

    public ObjectId insert(int type, long len, InputStream is) throws IOException {
        MessageDigest md = this.digest();
        File tmp = this.toTemp(md, type, len, is);
        ObjectId id = ObjectId.fromRaw(md.digest());
        if (this.db.has(id)) {
            tmp.delete();
            return id;
        }
        File dst = this.db.fileFor(id);
        if (tmp.renameTo(dst)) {
            return id;
        }
        dst.getParentFile().mkdir();
        if (tmp.renameTo(dst)) {
            return id;
        }
        if (this.db.has(id)) {
            tmp.delete();
            return id;
        }
        tmp.delete();
        throw new ObjectWritingException("Unable to create new object: " + dst);
    }

    public void flush() throws IOException {
    }

    public void release() {
        if (this.deflate != null) {
            try {
                this.deflate.end();
            }
            finally {
                this.deflate = null;
            }
        }
    }

    private File toTemp(MessageDigest md, int type, long len, InputStream is) throws IOException, FileNotFoundException, Error {
        boolean delete = true;
        File tmp = File.createTempFile("noz", null, this.db.getDirectory());
        try {
            DigestOutputStream dOut = new DigestOutputStream(this.compress(new FileOutputStream(tmp)), md);
            try {
                dOut.write(Constants.encodedTypeString(type));
                dOut.write(32);
                dOut.write(Constants.encodeASCII(len));
                dOut.write(0);
                byte[] buf = this.buffer();
                while (len > 0L) {
                    int n = is.read(buf, 0, (int)Math.min(len, (long)buf.length));
                    if (n <= 0) {
                        throw ObjectDirectoryInserter.shortInput(len);
                    }
                    dOut.write(buf, 0, n);
                    len -= (long)n;
                }
            }
            finally {
                dOut.close();
            }
            tmp.setReadOnly();
            delete = false;
            File file = tmp;
            return file;
        }
        finally {
            if (delete) {
                tmp.delete();
            }
        }
    }

    private DeflaterOutputStream compress(OutputStream out) {
        if (this.deflate == null) {
            this.deflate = new Deflater(this.config.get(CoreConfig.KEY).getCompression());
        } else {
            this.deflate.reset();
        }
        return new DeflaterOutputStream(out, this.deflate);
    }

    private static EOFException shortInput(long missing) {
        return new EOFException("Input did not match supplied length. " + missing + " bytes are missing.");
    }
}

