/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.LockFile;
import org.eclipse.jgit.storage.file.RefDirectoryRename;
import org.eclipse.jgit.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.RefList;
import org.eclipse.jgit.util.RefMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefDirectory
extends RefDatabase {
    public static final String SYMREF = "ref: ";
    public static final String PACKED_REFS_HEADER = "# pack-refs with:";
    public static final String PACKED_REFS_PEELED = " peeled";
    private final FileRepository parent;
    private final File gitDir;
    private final File refsDir;
    private final File logsDir;
    private final File logsRefsDir;
    private final File packedRefsFile;
    private final AtomicReference<RefList<LooseRef>> looseRefs = new AtomicReference();
    private final AtomicReference<PackedRefList> packedRefs = new AtomicReference();
    private final AtomicInteger modCnt = new AtomicInteger();
    private final AtomicInteger lastNotifiedModCnt = new AtomicInteger();

    RefDirectory(FileRepository db) {
        FS fs = db.getFS();
        this.parent = db;
        this.gitDir = db.getDirectory();
        this.refsDir = fs.resolve(this.gitDir, "refs/");
        this.logsDir = fs.resolve(this.gitDir, "logs");
        this.logsRefsDir = fs.resolve(this.gitDir, "logs/refs/");
        this.packedRefsFile = fs.resolve(this.gitDir, "packed-refs");
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(PackedRefList.NO_PACKED_REFS);
    }

    Repository getRepository() {
        return this.parent;
    }

    @Override
    public void create() throws IOException {
        this.refsDir.mkdir();
        this.logsDir.mkdir();
        this.logsRefsDir.mkdir();
        new File(this.refsDir, "refs/heads/".substring("refs/".length())).mkdir();
        new File(this.refsDir, "refs/tags/".substring("refs/".length())).mkdir();
        new File(this.logsRefsDir, "refs/heads/".substring("refs/".length())).mkdir();
    }

    @Override
    public void close() {
    }

    void rescan() {
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(PackedRefList.NO_PACKED_REFS);
    }

    @Override
    public boolean isNameConflicting(String name) throws IOException {
        PackedRefList packed = this.getPackedRefs();
        RefList<LooseRef> loose = this.getLooseRefs();
        int lastSlash = name.lastIndexOf(47);
        while (lastSlash > 0) {
            String needle = name.substring(0, lastSlash);
            if (loose.contains(needle) || packed.contains(needle)) {
                return true;
            }
            lastSlash = name.lastIndexOf(47, lastSlash - 1);
        }
        String prefix = String.valueOf(name) + '/';
        int idx = -(packed.find(prefix) + 1);
        if (idx < packed.size() && packed.get(idx).getName().startsWith(prefix)) {
            return true;
        }
        idx = -(loose.find(prefix) + 1);
        return idx < loose.size() && loose.get(idx).getName().startsWith(prefix);
    }

    private RefList<LooseRef> getLooseRefs() {
        RefList<LooseRef> loose;
        RefList<LooseRef> oldLoose = this.looseRefs.get();
        LooseScanner scan = new LooseScanner(oldLoose);
        scan.scan("");
        if (scan.newLoose != null) {
            loose = scan.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(oldLoose, loose)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            loose = oldLoose;
        }
        return loose;
    }

    @Override
    public Ref getRef(String needle) throws IOException {
        PackedRefList packed = this.getPackedRefs();
        Ref ref = null;
        String[] stringArray = SEARCH_PATH;
        int n = SEARCH_PATH.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            ref = this.readRef(String.valueOf(prefix) + needle, packed);
            if (ref != null) {
                ref = this.resolve(ref, 0, null, null, packed);
                break;
            }
            ++n2;
        }
        this.fireRefsChanged();
        return ref;
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        RefList<LooseRef> loose;
        PackedRefList packed = this.getPackedRefs();
        RefList<LooseRef> oldLoose = this.looseRefs.get();
        LooseScanner scan = new LooseScanner(oldLoose);
        scan.scan(prefix);
        if (scan.newLoose != null) {
            loose = scan.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(oldLoose, loose)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            loose = oldLoose;
        }
        this.fireRefsChanged();
        RefList.Builder<Ref> symbolic = scan.symbolic;
        int idx = 0;
        while (idx < symbolic.size()) {
            Ref ref = symbolic.get(idx);
            if ((ref = this.resolve(ref, 0, prefix, loose, packed)) != null && ref.getObjectId() != null) {
                symbolic.set(idx, ref);
                ++idx;
                continue;
            }
            loose = loose.remove(idx);
            symbolic.remove(idx);
        }
        return new RefMap(prefix, packed, this.upcast(loose), symbolic.toRefList());
    }

    private RefList<Ref> upcast(RefList<? extends Ref> loose) {
        return loose;
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        RefList<LooseRef> curList;
        int idx;
        Ref leaf = ref.getLeaf();
        if (leaf.isPeeled() || leaf.getObjectId() == null) {
            return ref;
        }
        ObjectIdRef newLeaf = this.doPeel(leaf);
        if (leaf.getStorage().isLoose() && (idx = (curList = this.looseRefs.get()).find(leaf.getName())) >= 0 && curList.get(idx) == leaf) {
            LooseRef asPeeled = ((LooseRef)leaf).peel(newLeaf);
            RefList<LooseRef> newList = curList.set(idx, asPeeled);
            this.looseRefs.compareAndSet(curList, newList);
        }
        return RefDirectory.recreate(ref, newLeaf);
    }

    private ObjectIdRef doPeel(Ref leaf) throws MissingObjectException, IOException {
        RevWalk rw = new RevWalk(this.getRepository());
        try {
            RevObject obj = rw.parseAny(leaf.getObjectId());
            if (obj instanceof RevTag) {
                ObjectIdRef.PeeledTag peeledTag = new ObjectIdRef.PeeledTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId(), rw.peel(obj).copy());
                return peeledTag;
            }
            ObjectIdRef.PeeledNonTag peeledNonTag = new ObjectIdRef.PeeledNonTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId());
            return peeledNonTag;
        }
        finally {
            rw.release();
        }
    }

    private static Ref recreate(Ref old, ObjectIdRef leaf) {
        if (old.isSymbolic()) {
            Ref dst = RefDirectory.recreate(old.getTarget(), leaf);
            return new SymbolicRef(old.getName(), dst);
        }
        return leaf;
    }

    void storedSymbolicRef(RefDirectoryUpdate u, long modified, String target) {
        this.putLooseRef(RefDirectory.newSymbolicRef(modified, u.getRef().getName(), target));
        this.fireRefsChanged();
    }

    @Override
    public RefDirectoryUpdate newUpdate(String name, boolean detach) throws IOException {
        PackedRefList packed = this.getPackedRefs();
        Ref ref = this.readRef(name, packed);
        if (ref != null) {
            ref = this.resolve(ref, 0, null, null, packed);
        }
        if (ref == null) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        } else if (detach && ref.isSymbolic()) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, ref.getObjectId());
        }
        return new RefDirectoryUpdate(this, ref);
    }

    @Override
    public RefDirectoryRename newRename(String fromName, String toName) throws IOException {
        RefDirectoryUpdate from = this.newUpdate(fromName, false);
        RefDirectoryUpdate to = this.newUpdate(toName, false);
        return new RefDirectoryRename(from, to);
    }

    void stored(RefDirectoryUpdate update, long modified) {
        ObjectId target = update.getNewObjectId().copy();
        Ref leaf = update.getRef().getLeaf();
        this.putLooseRef(new LooseUnpeeled(modified, leaf.getName(), target));
    }

    private void putLooseRef(LooseRef ref) {
        RefList<LooseRef> nList;
        RefList<LooseRef> cList;
        while (!this.looseRefs.compareAndSet(cList = this.looseRefs.get(), nList = cList.put(ref))) {
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    void delete(RefDirectoryUpdate update) throws IOException {
        RefList<LooseRef> newLoose;
        RefList<LooseRef> curLoose;
        int idx;
        Ref dst = update.getRef().getLeaf();
        String name = dst.getName();
        PackedRefList packed = this.getPackedRefs();
        if (packed.contains(name)) {
            LockFile lck = new LockFile(this.packedRefsFile, update.getRepository().getFS());
            if (!lck.lock()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotLockFile, this.packedRefsFile));
            }
            try {
                PackedRefList cur = this.readPackedRefs(0L, 0L);
                idx = cur.find(name);
                if (idx >= 0) {
                    this.commitPackedRefs(lck, cur.remove(idx), packed);
                }
            }
            finally {
                lck.unlock();
            }
        }
        while ((idx = (curLoose = this.looseRefs.get()).find(name)) >= 0 && !this.looseRefs.compareAndSet(curLoose, newLoose = curLoose.remove(idx))) {
        }
        int levels = RefDirectory.levelsIn(name) - 2;
        RefDirectory.delete(this.logFor(name), levels);
        if (dst.getStorage().isLoose()) {
            update.unlock();
            RefDirectory.delete(this.fileFor(name), levels);
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    void log(RefUpdate update, String msg, boolean deref) throws IOException {
        ObjectId oldId = update.getOldObjectId();
        ObjectId newId = update.getNewObjectId();
        Ref ref = update.getRef();
        PersonIdent ident = update.getRefLogIdent();
        ident = ident == null ? new PersonIdent(this.parent) : new PersonIdent(ident);
        StringBuilder r = new StringBuilder();
        r.append(ObjectId.toString(oldId));
        r.append(' ');
        r.append(ObjectId.toString(newId));
        r.append(' ');
        r.append(ident.toExternalString());
        r.append('\t');
        r.append(msg);
        r.append('\n');
        byte[] rec = Constants.encode(r.toString());
        if (deref && ref.isSymbolic()) {
            this.log(ref.getName(), rec);
            this.log(ref.getLeaf().getName(), rec);
        } else {
            this.log(ref.getName(), rec);
        }
    }

    private void log(String refName, byte[] rec) throws IOException {
        File log = this.logFor(refName);
        boolean write = this.isLogAllRefUpdates() && this.shouldAutoCreateLog(refName) ? true : log.isFile();
        if (write) {
            FileOutputStream out;
            try {
                out = new FileOutputStream(log, true);
            }
            catch (FileNotFoundException err) {
                File dir = log.getParentFile();
                if (dir.exists()) {
                    throw err;
                }
                if (!dir.mkdirs() && !dir.isDirectory()) {
                    throw new IOException(MessageFormat.format(JGitText.get().cannotCreateDirectory, dir));
                }
                out = new FileOutputStream(log, true);
            }
            try {
                out.write(rec);
            }
            finally {
                out.close();
            }
        }
    }

    private boolean isLogAllRefUpdates() {
        return this.parent.getConfig().get(CoreConfig.KEY).isLogAllRefUpdates();
    }

    private boolean shouldAutoCreateLog(String refName) {
        return refName.equals("HEAD") || refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ref resolve(Ref ref, int depth, String prefix, RefList<LooseRef> loose, RefList<Ref> packed) throws IOException {
        if (!ref.isSymbolic()) return ref;
        Ref dst = ref.getTarget();
        if (5 <= depth) {
            return null;
        }
        if (loose != null && dst.getName().startsWith(prefix)) {
            int idx = loose.find(dst.getName());
            if (idx >= 0) {
                dst = loose.get(idx);
            } else {
                idx = packed.find(dst.getName());
                if (idx < 0) return ref;
                dst = packed.get(idx);
            }
        } else if ((dst = this.readRef(dst.getName(), packed)) == null) {
            return ref;
        }
        dst = this.resolve(dst, depth + 1, prefix, loose, packed);
        if (dst != null) return new SymbolicRef(ref.getName(), dst);
        return null;
    }

    private PackedRefList getPackedRefs() throws IOException {
        long size = this.packedRefsFile.length();
        long mtime = size != 0L ? this.packedRefsFile.lastModified() : 0L;
        PackedRefList curList = this.packedRefs.get();
        if (size == curList.lastSize && mtime == curList.lastModified) {
            return curList;
        }
        PackedRefList newList = this.readPackedRefs(size, mtime);
        if (this.packedRefs.compareAndSet(curList, newList)) {
            this.modCnt.incrementAndGet();
        }
        return newList;
    }

    private PackedRefList readPackedRefs(long size, long mtime) throws IOException {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.packedRefsFile), Constants.CHARSET));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return PackedRefList.NO_PACKED_REFS;
        }
        try {
            PackedRefList packedRefList = new PackedRefList(this.parsePackedRefs(br), size, mtime);
            return packedRefList;
        }
        finally {
            br.close();
        }
    }

    private RefList<Ref> parsePackedRefs(BufferedReader br) throws IOException {
        String p;
        RefList.Builder<Ref> all = new RefList.Builder<Ref>();
        Ref last = null;
        boolean peeled = false;
        boolean needSort = false;
        while ((p = br.readLine()) != null) {
            if (p.charAt(0) == '#') {
                if (!p.startsWith(PACKED_REFS_HEADER)) continue;
                p = p.substring(PACKED_REFS_HEADER.length());
                peeled = p.contains(PACKED_REFS_PEELED);
                continue;
            }
            if (p.charAt(0) == '^') {
                if (last == null) {
                    throw new IOException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId id = ObjectId.fromString(p.substring(1));
                last = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id);
                all.set(all.size() - 1, last);
                continue;
            }
            int sp = p.indexOf(32);
            ObjectId id = ObjectId.fromString(p.substring(0, sp));
            String name = RefDirectory.copy(p, sp + 1, p.length());
            ObjectIdRef cur = peeled ? new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id) : new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name, id);
            if (last != null && RefComparator.compareTo(last, cur) > 0) {
                needSort = true;
            }
            all.add(cur);
            last = cur;
        }
        if (needSort) {
            all.sort();
        }
        return all.toRefList();
    }

    private static String copy(String src, int off, int end) {
        return new StringBuilder(end - off).append(src, off, end).toString();
    }

    private void commitPackedRefs(final LockFile lck, final RefList<Ref> refs, final PackedRefList oldPackedList) throws IOException {
        new RefWriter(refs){

            protected void writeFile(String name, byte[] content) throws IOException {
                lck.setNeedStatInformation(true);
                try {
                    lck.write(content);
                }
                catch (IOException ioe) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name), ioe);
                }
                try {
                    lck.waitForStatChange();
                }
                catch (InterruptedException interruptedException) {
                    lck.unlock();
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().interruptedWriting, name));
                }
                if (!lck.commit()) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name));
                }
                RefDirectory.this.packedRefs.compareAndSet(oldPackedList, new PackedRefList(refs, content.length, lck.getCommitLastModified()));
            }
        }.writePackedRefs();
    }

    private Ref readRef(String name, RefList<Ref> packed) throws IOException {
        RefList<LooseRef> curList = this.looseRefs.get();
        int idx = curList.find(name);
        if (idx >= 0) {
            LooseRef o = curList.get(idx);
            LooseRef n = this.scanRef(o, name);
            if (n == null) {
                if (this.looseRefs.compareAndSet(curList, curList.remove(idx))) {
                    this.modCnt.incrementAndGet();
                }
                return packed.get(name);
            }
            if (o == n) {
                return n;
            }
            if (this.looseRefs.compareAndSet(curList, curList.set(idx, n))) {
                this.modCnt.incrementAndGet();
            }
            return n;
        }
        LooseRef n = this.scanRef(null, name);
        if (n == null) {
            return packed.get(name);
        }
        if (this.looseRefs.compareAndSet(curList, curList.add(idx, n))) {
            this.modCnt.incrementAndGet();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private LooseRef scanRef(LooseRef ref, String name) throws IOException {
        block14: {
            path = this.fileFor(name);
            modified = path.lastModified();
            if (ref != null) {
                if (ref.getLastModified() == modified) {
                    return ref;
                }
                name = ref.getName();
            } else if (modified == 0L) {
                return null;
            }
            try {
                buf = IO.readFully(path, 4096);
            }
            catch (FileNotFoundException v0) {
                return null;
            }
            n = buf.length;
            if (n == 0) {
                return null;
            }
            if (RefDirectory.isSymRef(buf, n)) {
                while (n > 0 && Character.isWhitespace(buf[n - 1])) {
                    --n;
                }
                if (n < 6) {
                    content = RawParseUtils.decode(buf, 0, n);
                    throw new IOException(MessageFormat.format(JGitText.get().notARef, new Object[]{name, content}));
                }
                target = RawParseUtils.decode(buf, 5, n);
                return RefDirectory.newSymbolicRef(modified, name, target);
            }
            if (n < 40) {
                return null;
            }
            try {
                id = ObjectId.fromString(buf, 0);
                break block14;
            }
            catch (IllegalArgumentException v1) {
                ** while (n > 0 && Character.isWhitespace((int)buf[n - 1]))
            }
lbl-1000:
            // 1 sources

            {
                --n;
                continue;
            }
lbl36:
            // 1 sources

            content = RawParseUtils.decode(buf, 0, n);
            throw new IOException(MessageFormat.format(JGitText.get().notARef, new Object[]{name, content}));
        }
        return new LooseUnpeeled(modified, name, id);
    }

    private static boolean isSymRef(byte[] buf, int n) {
        if (n < 6) {
            return false;
        }
        return buf[0] == 114 && buf[1] == 101 && buf[2] == 102 && buf[3] == 58 && buf[4] == 32;
    }

    private void fireRefsChanged() {
        int curr;
        int last = this.lastNotifiedModCnt.get();
        if (last != (curr = this.modCnt.get()) && this.lastNotifiedModCnt.compareAndSet(last, curr)) {
            this.parent.fireEvent(new RefsChangedEvent());
        }
    }

    RefDirectoryUpdate newTemporaryUpdate() throws IOException {
        File tmp = File.createTempFile("renamed_", "_ref", this.refsDir);
        String name = "refs/" + tmp.getName();
        ObjectIdRef.Unpeeled ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        return new RefDirectoryUpdate(this, ref);
    }

    File fileFor(String name) {
        if (name.startsWith("refs/")) {
            name = name.substring("refs/".length());
            return new File(this.refsDir, name);
        }
        return new File(this.gitDir, name);
    }

    File logFor(String name) {
        if (name.startsWith("refs/")) {
            name = name.substring("refs/".length());
            return new File(this.logsRefsDir, name);
        }
        return new File(this.logsDir, name);
    }

    static int levelsIn(String name) {
        int count = 0;
        int p = name.indexOf(47);
        while (p >= 0) {
            ++count;
            p = name.indexOf(47, p + 1);
        }
        return count;
    }

    static void delete(File file, int depth) throws IOException {
        if (!file.delete() && file.isFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().fileCannotBeDeleted, file));
        }
        File dir = file.getParentFile();
        int i = 0;
        while (i < depth) {
            if (!dir.delete()) break;
            dir = dir.getParentFile();
            ++i;
        }
    }

    private static LooseSymbolicRef newSymbolicRef(long lastModified, String name, String target) {
        ObjectIdRef.Unpeeled dst = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
        return new LooseSymbolicRef(lastModified, name, dst);
    }

    private static final class LooseNonTag
    extends ObjectIdRef.PeeledNonTag
    implements LooseRef {
        private final long lastModified;

        LooseNonTag(long mtime, String refName, ObjectId id) {
            super(Ref.Storage.LOOSE, refName, id);
            this.lastModified = mtime;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static final class LoosePeeledTag
    extends ObjectIdRef.PeeledTag
    implements LooseRef {
        private final long lastModified;

        LoosePeeledTag(long mtime, String refName, ObjectId id, ObjectId p) {
            super(Ref.Storage.LOOSE, refName, id, p);
            this.lastModified = mtime;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static interface LooseRef
    extends Ref {
        public long getLastModified();

        public LooseRef peel(ObjectIdRef var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LooseScanner {
        private final RefList<LooseRef> curLoose;
        private int curIdx;
        final RefList.Builder<Ref> symbolic = new RefList.Builder(4);
        RefList.Builder<LooseRef> newLoose;

        LooseScanner(RefList<LooseRef> curLoose) {
            this.curLoose = curLoose;
        }

        void scan(String prefix) {
            if ("".equals(prefix)) {
                this.scanOne("HEAD");
                this.scanTree("refs/", RefDirectory.this.refsDir);
                if (this.newLoose == null && this.curIdx < this.curLoose.size()) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
            } else if (prefix.startsWith("refs/") && prefix.endsWith("/")) {
                this.curIdx = -(this.curLoose.find(prefix) + 1);
                File dir = new File(RefDirectory.this.refsDir, prefix.substring("refs/".length()));
                this.scanTree(prefix, dir);
                while (this.curIdx < this.curLoose.size()) {
                    if (!this.curLoose.get(this.curIdx).getName().startsWith(prefix)) break;
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                }
                if (this.newLoose != null) {
                    while (this.curIdx < this.curLoose.size()) {
                        this.newLoose.add(this.curLoose.get(this.curIdx++));
                    }
                }
            }
        }

        private boolean scanTree(String prefix, File dir) {
            Object[] entries = dir.list(LockFile.FILTER);
            if (entries == null) {
                return false;
            }
            if (entries.length > 0) {
                Arrays.sort(entries);
                Object[] objectArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    Object name = objectArray[n2];
                    File e = new File(dir, (String)name);
                    if (!this.scanTree(String.valueOf(prefix) + (String)name + '/', e)) {
                        this.scanOne(String.valueOf(prefix) + (String)name);
                    }
                    ++n2;
                }
            }
            return true;
        }

        private void scanOne(String name) {
            LooseRef n;
            LooseRef cur;
            if (this.curIdx < this.curLoose.size()) {
                do {
                    int cmp;
                    if ((cmp = RefComparator.compareTo((Ref)(cur = this.curLoose.get(this.curIdx)), name)) >= 0) {
                        if (cmp > 0) {
                            cur = null;
                        }
                        break;
                    }
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                    cur = null;
                } while (this.curIdx < this.curLoose.size());
            } else {
                cur = null;
            }
            try {
                n = RefDirectory.this.scanRef(cur, name);
            }
            catch (IOException iOException) {
                n = null;
            }
            if (n != null) {
                if (cur != n && this.newLoose == null) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
                if (this.newLoose != null) {
                    this.newLoose.add(n);
                }
                if (n.isSymbolic()) {
                    this.symbolic.add(n);
                }
            } else if (cur != null && this.newLoose == null) {
                this.newLoose = this.curLoose.copy(this.curIdx);
            }
            if (cur != null) {
                ++this.curIdx;
            }
        }
    }

    private static final class LooseSymbolicRef
    extends SymbolicRef
    implements LooseRef {
        private final long lastModified;

        LooseSymbolicRef(long mtime, String refName, Ref target) {
            super(refName, target);
            this.lastModified = mtime;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LooseUnpeeled
    extends ObjectIdRef.Unpeeled
    implements LooseRef {
        private final long lastModified;

        LooseUnpeeled(long mtime, String refName, ObjectId id) {
            super(Ref.Storage.LOOSE, refName, id);
            this.lastModified = mtime;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public LooseRef peel(ObjectIdRef newLeaf) {
            if (newLeaf.getPeeledObjectId() != null) {
                return new LoosePeeledTag(this.lastModified, this.getName(), this.getObjectId(), newLeaf.getPeeledObjectId());
            }
            return new LooseNonTag(this.lastModified, this.getName(), this.getObjectId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackedRefList
    extends RefList<Ref> {
        static final PackedRefList NO_PACKED_REFS = new PackedRefList(RefList.<Ref>emptyList(), 0L, 0L);
        final long lastSize;
        final long lastModified;

        PackedRefList(RefList<Ref> src, long size, long mtime) {
            super(src);
            this.lastSize = size;
            this.lastModified = mtime;
        }
    }
}

