/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.transport.PackedObjectInfo;

public class ObjectToPack
extends PackedObjectInfo {
    private static final int WANT_WRITE = 1;
    private static final int REUSE_AS_IS = 2;
    private static final int DO_NOT_DELTA = 4;
    private static final int TYPE_SHIFT = 5;
    private static final int DELTA_SHIFT = 8;
    private static final int NON_DELTA_MASK = 255;
    private ObjectId deltaBase;
    private int flags;
    private int pathHash;
    private DeltaCache.Ref cachedDelta;

    public ObjectToPack(AnyObjectId src, int type) {
        super(src);
        this.flags = type << 5;
    }

    public ObjectToPack(RevObject obj) {
        this(obj, obj.getType());
    }

    ObjectId getDeltaBaseId() {
        return this.deltaBase;
    }

    ObjectToPack getDeltaBase() {
        if (this.deltaBase instanceof ObjectToPack) {
            return (ObjectToPack)this.deltaBase;
        }
        return null;
    }

    void setDeltaBase(ObjectId deltaBase) {
        this.deltaBase = deltaBase;
    }

    void setCachedDelta(DeltaCache.Ref data) {
        this.cachedDelta = data;
    }

    DeltaCache.Ref popCachedDelta() {
        DeltaCache.Ref r = this.cachedDelta;
        if (r != null) {
            this.cachedDelta = null;
        }
        return r;
    }

    void clearDeltaBase() {
        this.deltaBase = null;
        if (this.cachedDelta != null) {
            this.cachedDelta.clear();
            this.cachedDelta.enqueue();
            this.cachedDelta = null;
        }
    }

    boolean isDeltaRepresentation() {
        return this.deltaBase != null;
    }

    boolean isWritten() {
        return this.getOffset() != 0L;
    }

    int getType() {
        return this.flags >> 5 & 7;
    }

    int getDeltaDepth() {
        return this.flags >>> 8;
    }

    void setDeltaDepth(int d) {
        this.flags = d << 8 | this.flags & 0xFF;
    }

    boolean wantWrite() {
        return (this.flags & 1) != 0;
    }

    void markWantWrite() {
        this.flags |= 1;
    }

    boolean isReuseAsIs() {
        return (this.flags & 2) != 0;
    }

    void setReuseAsIs() {
        this.flags |= 2;
    }

    protected void clearReuseAsIs() {
        this.flags &= 0xFFFFFFFD;
    }

    boolean isDoNotDelta() {
        return (this.flags & 4) != 0;
    }

    void setDoNotDelta(boolean noDelta) {
        this.flags = noDelta ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    int getFormat() {
        if (this.isReuseAsIs()) {
            if (this.isDeltaRepresentation()) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    int getWeight() {
        return this.getCRC();
    }

    void setWeight(int weight) {
        this.setCRC(weight);
    }

    int getPathHash() {
        return this.pathHash;
    }

    void setPathHash(int hc) {
        this.pathHash = hc;
    }

    int getCachedSize() {
        return this.pathHash;
    }

    void setCachedSize(int sz) {
        this.pathHash = sz;
    }

    public void select(StoredObjectRepresentation ref) {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ObjectToPack[");
        buf.append(Constants.typeString(this.getType()));
        buf.append(" ");
        buf.append(this.name());
        if (this.wantWrite()) {
            buf.append(" wantWrite");
        }
        if (this.isReuseAsIs()) {
            buf.append(" reuseAsIs");
        }
        if (this.isDoNotDelta()) {
            buf.append(" doNotDelta");
        }
        if (this.getDeltaDepth() > 0) {
            buf.append(" depth=" + this.getDeltaDepth());
        }
        if (this.isDeltaRepresentation()) {
            if (this.getDeltaBase() != null) {
                buf.append(" base=inpack:" + this.getDeltaBase().name());
            } else {
                buf.append(" base=edge:" + this.getDeltaBaseId().name());
            }
        }
        if (this.isWritten()) {
            buf.append(" offset=" + this.getOffset());
        }
        buf.append("]");
        return buf.toString();
    }
}

