/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.NB;

public final class PackOutputStream
extends OutputStream {
    private final ProgressMonitor writeMonitor;
    private final OutputStream out;
    private final boolean ofsDelta;
    private final CRC32 crc = new CRC32();
    private final MessageDigest md = Constants.newMessageDigest();
    private long count;
    private byte[] headerBuffer = new byte[32];
    private byte[] copyBuffer;

    public PackOutputStream(ProgressMonitor writeMonitor, OutputStream out, PackWriter pw) {
        this.writeMonitor = writeMonitor;
        this.out = out;
        this.ofsDelta = pw.isDeltaBaseAsOffset();
    }

    public void write(int b) throws IOException {
        ++this.count;
        this.out.write(b);
        this.crc.update(b);
        this.md.update((byte)b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.count += (long)len;
        this.out.write(b, off, len);
        this.crc.update(b, off, len);
        this.md.update(b, off, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    void writeFileHeader(int version, int objectCount) throws IOException {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, this.headerBuffer, 0, 4);
        NB.encodeInt32(this.headerBuffer, 4, version);
        NB.encodeInt32(this.headerBuffer, 8, objectCount);
        this.write(this.headerBuffer, 0, 12);
    }

    public void writeHeader(ObjectToPack otp, long rawLength) throws IOException {
        if (otp.isDeltaRepresentation()) {
            ObjectToPack baseInPack;
            if (this.ofsDelta && (baseInPack = otp.getDeltaBase()) != null && baseInPack.isWritten()) {
                long start = this.count;
                int n = this.encodeTypeSize(6, rawLength);
                this.write(this.headerBuffer, 0, n);
                long offsetDiff = start - baseInPack.getOffset();
                n = this.headerBuffer.length - 1;
                this.headerBuffer[n] = (byte)(offsetDiff & 0x7FL);
                while ((offsetDiff >>= 7) > 0L) {
                    this.headerBuffer[--n] = (byte)(0x80L | --offsetDiff & 0x7FL);
                }
                this.write(this.headerBuffer, n, this.headerBuffer.length - n);
                return;
            }
            int n = this.encodeTypeSize(7, rawLength);
            otp.getDeltaBaseId().copyRawTo(this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n + 20);
        } else {
            int n = this.encodeTypeSize(otp.getType(), rawLength);
            this.write(this.headerBuffer, 0, n);
        }
    }

    private int encodeTypeSize(int type, long rawLength) {
        long nextLength = rawLength >>> 4;
        this.headerBuffer[0] = (byte)((long)((nextLength > 0L ? 128 : 0) | type << 4) | rawLength & 0xFL);
        rawLength = nextLength;
        int n = 1;
        while (rawLength > 0L) {
            this.headerBuffer[n++] = (byte)((long)((nextLength >>>= 7) > 0L ? 128 : 0) | rawLength & 0x7FL);
            rawLength = nextLength;
        }
        return n;
    }

    public byte[] getCopyBuffer() {
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[16384];
        }
        return this.copyBuffer;
    }

    void endObject() {
        this.writeMonitor.update(1);
    }

    long length() {
        return this.count;
    }

    int getCRC32() {
        return (int)this.crc.getValue();
    }

    void resetCRC32() {
        this.crc.reset();
    }

    byte[] getDigest() {
        return this.md.digest();
    }
}

