/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackWriter;

class ThreadSafeDeltaCache
extends DeltaCache {
    private final ReentrantLock lock = new ReentrantLock();

    ThreadSafeDeltaCache(PackWriter pw) {
        super(pw);
    }

    boolean canCache(int length, ObjectToPack src, ObjectToPack res) {
        this.lock.lock();
        try {
            boolean bl = super.canCache(length, src, res);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void credit(int reservedSize) {
        this.lock.lock();
        try {
            super.credit(reservedSize);
        }
        finally {
            this.lock.unlock();
        }
    }

    DeltaCache.Ref cache(byte[] data, int actLen, int reservedSize) {
        data = this.resize(data, actLen);
        this.lock.lock();
        try {
            DeltaCache.Ref ref = super.cache(data, actLen, reservedSize);
            return ref;
        }
        finally {
            this.lock.unlock();
        }
    }
}

