/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.PackLock;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.IndexPack;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.SideBandInputStream;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BasePackFetchConnection
extends BasePackConnection
implements FetchConnection {
    private static final int MAX_HAVES = 256;
    protected static final int MIN_CLIENT_BUFFER = 2952;
    static final String OPTION_INCLUDE_TAG = "include-tag";
    static final String OPTION_MULTI_ACK = "multi_ack";
    static final String OPTION_MULTI_ACK_DETAILED = "multi_ack_detailed";
    static final String OPTION_THIN_PACK = "thin-pack";
    static final String OPTION_SIDE_BAND = "side-band";
    static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    static final String OPTION_OFS_DELTA = "ofs-delta";
    static final String OPTION_SHALLOW = "shallow";
    static final String OPTION_NO_PROGRESS = "no-progress";
    private final RevWalk walk;
    private RevCommitList<RevCommit> reachableCommits;
    final RevFlag REACHABLE;
    final RevFlag COMMON;
    private final RevFlag STATE;
    final RevFlag ADVERTISED;
    private MultiAck multiAck = MultiAck.OFF;
    private boolean thinPack;
    private boolean sideband;
    private boolean includeTags;
    private boolean allowOfsDelta;
    private String lockMessage;
    private PackLock packLock;
    private TemporaryBuffer.Heap state;
    private PacketLineOut pckState;

    BasePackFetchConnection(PackTransport packTransport) {
        super(packTransport);
        FetchConfig cfg = this.local.getConfig().get(FetchConfig.KEY);
        this.includeTags = this.transport.getTagOpt() != TagOpt.NO_TAGS;
        this.thinPack = this.transport.isFetchThin();
        this.allowOfsDelta = cfg.allowOfsDelta;
        this.walk = new RevWalk(this.local);
        this.reachableCommits = new RevCommitList();
        this.REACHABLE = this.walk.newFlag("REACHABLE");
        this.COMMON = this.walk.newFlag("COMMON");
        this.STATE = this.walk.newFlag("STATE");
        this.ADVERTISED = this.walk.newFlag("ADVERTISED");
        this.walk.carry(this.COMMON);
        this.walk.carry(this.REACHABLE);
        this.walk.carry(this.ADVERTISED);
    }

    @Override
    public final void fetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.markStartedOperation();
        this.doFetch(monitor, want, have);
    }

    @Override
    public boolean didFetchIncludeTags() {
        return false;
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        try {
            this.markRefsAdvertised();
            this.markReachable(have, this.maxTimeWanted(want));
            if (this.statelessRPC) {
                this.state = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
                this.pckState = new PacketLineOut(this.state);
            }
            if (this.sendWants(want)) {
                this.negotiate(monitor);
                this.walk.dispose();
                this.reachableCommits = null;
                this.state = null;
                this.pckState = null;
                this.receivePack(monitor);
            }
        }
        catch (CancelledException cancelledException) {
            this.close();
            return;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    @Override
    public void close() {
        this.walk.release();
        super.close();
    }

    private int maxTimeWanted(Collection<Ref> wants) {
        int maxTime = 0;
        for (Ref r : wants) {
            try {
                int cTime;
                RevObject obj = this.walk.parseAny(r.getObjectId());
                if (!(obj instanceof RevCommit) || maxTime >= (cTime = ((RevCommit)obj).getCommitTime())) continue;
                maxTime = cTime;
            }
            catch (IOException iOException) {}
        }
        return maxTime;
    }

    private void markReachable(Set<ObjectId> have, int maxTime) throws IOException {
        RevCommit o;
        for (Ref r : this.local.getAllRefs().values()) {
            try {
                o = this.walk.parseCommit(r.getObjectId());
                o.add(this.REACHABLE);
                this.reachableCommits.add(o);
            }
            catch (IOException iOException) {}
        }
        for (ObjectId id : have) {
            try {
                o = this.walk.parseCommit(id);
                o.add(this.REACHABLE);
                this.reachableCommits.add(o);
            }
            catch (IOException iOException) {}
        }
        if (maxTime > 0) {
            RevCommit c;
            Date maxWhen = new Date((long)maxTime * 1000L);
            this.walk.sort(RevSort.COMMIT_TIME_DESC);
            this.walk.markStart(this.reachableCommits);
            this.walk.setRevFilter(CommitTimeRevFilter.after(maxWhen));
            while ((c = this.walk.next()) != null) {
                if (!c.has(this.ADVERTISED) || c.has(this.COMMON)) continue;
                c.add(this.COMMON);
                c.carry(this.COMMON);
                this.reachableCommits.add(c);
            }
        }
    }

    private boolean sendWants(Collection<Ref> want) throws IOException {
        PacketLineOut p = this.statelessRPC ? this.pckState : this.pckOut;
        boolean first = true;
        for (Ref r : want) {
            try {
                if (this.walk.parseAny(r.getObjectId()).has(this.REACHABLE)) {
                    continue;
                }
            }
            catch (IOException iOException) {}
            StringBuilder line = new StringBuilder(46);
            line.append("want ");
            line.append(r.getObjectId().name());
            if (first) {
                line.append(this.enableCapabilities());
                first = false;
            }
            line.append('\n');
            p.writeString(line.toString());
        }
        if (first) {
            return false;
        }
        p.end();
        this.outNeedsEnd = false;
        return true;
    }

    private String enableCapabilities() throws TransportException {
        StringBuilder line = new StringBuilder();
        if (this.includeTags) {
            this.includeTags = this.wantCapability(line, OPTION_INCLUDE_TAG);
        }
        if (this.allowOfsDelta) {
            this.wantCapability(line, OPTION_OFS_DELTA);
        }
        this.multiAck = this.wantCapability(line, OPTION_MULTI_ACK_DETAILED) ? MultiAck.DETAILED : (this.wantCapability(line, OPTION_MULTI_ACK) ? MultiAck.CONTINUE : MultiAck.OFF);
        if (this.thinPack) {
            this.thinPack = this.wantCapability(line, OPTION_THIN_PACK);
        }
        if (this.wantCapability(line, OPTION_SIDE_BAND_64K)) {
            this.sideband = true;
        } else if (this.wantCapability(line, OPTION_SIDE_BAND)) {
            this.sideband = true;
        }
        if (this.statelessRPC && this.multiAck != MultiAck.DETAILED) {
            throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().statelessRPCRequiresOptionToBeEnabled, OPTION_MULTI_ACK_DETAILED));
        }
        return line.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void negotiate(ProgressMonitor monitor) throws IOException, CancelledException {
        RevCommit c;
        MutableObjectId ackId = new MutableObjectId();
        int resultsPending = 0;
        int havesSent = 0;
        int havesSinceLastContinue = 0;
        boolean receivedContinue = false;
        boolean receivedAck = false;
        if (this.statelessRPC) {
            this.state.writeTo(this.out, null);
        }
        this.negotiateBegin();
        block10: while ((c = this.walk.next()) != null) {
            this.pckOut.writeString("have " + c.getId().name() + "\n");
            ++havesSinceLastContinue;
            if ((0x1F & ++havesSent) != 0) continue;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.pckOut.end();
            ++resultsPending;
            if (havesSent == 32 && !this.statelessRPC) continue;
            block11: while (true) {
                PacketLineIn.AckNackResult anr = this.pckIn.readACK(ackId);
                switch (anr) {
                    case NAK: {
                        --resultsPending;
                        break block11;
                    }
                    case ACK: {
                        this.multiAck = MultiAck.OFF;
                        resultsPending = 0;
                        receivedAck = true;
                        if (!this.statelessRPC) break block10;
                        this.state.writeTo(this.out, null);
                        break block10;
                    }
                    case ACK_CONTINUE: 
                    case ACK_COMMON: 
                    case ACK_READY: {
                        this.markCommon(this.walk.parseAny(ackId), anr);
                        receivedAck = true;
                        receivedContinue = true;
                        havesSinceLastContinue = 0;
                    }
                    default: {
                        if (!monitor.isCancelled()) continue block11;
                        throw new CancelledException();
                    }
                }
                break;
            }
            if (this.statelessRPC) {
                this.state.writeTo(this.out, null);
            }
            if (!receivedContinue || havesSinceLastContinue <= 256) continue;
        }
        if (monitor.isCancelled()) {
            throw new CancelledException();
        }
        this.pckOut.writeString("done\n");
        this.pckOut.flush();
        if (!receivedAck) {
            this.multiAck = MultiAck.OFF;
            ++resultsPending;
        }
        while (resultsPending > 0 || this.multiAck != MultiAck.OFF) {
            PacketLineIn.AckNackResult anr = this.pckIn.readACK(ackId);
            --resultsPending;
            switch (anr) {
                case NAK: {
                    break;
                }
                case ACK: {
                    return;
                }
                case ACK_CONTINUE: 
                case ACK_COMMON: 
                case ACK_READY: {
                    this.multiAck = MultiAck.CONTINUE;
                }
            }
            if (!monitor.isCancelled()) continue;
            throw new CancelledException();
        }
    }

    private void negotiateBegin() throws IOException {
        this.walk.resetRetain(this.REACHABLE, this.ADVERTISED);
        this.walk.markStart(this.reachableCommits);
        this.walk.sort(RevSort.COMMIT_TIME_DESC);
        this.walk.setRevFilter(new RevFilter(){

            public RevFilter clone() {
                return this;
            }

            public boolean include(RevWalk walker, RevCommit c) {
                boolean remoteKnowsIsCommon = c.has(BasePackFetchConnection.this.COMMON);
                if (c.has(BasePackFetchConnection.this.ADVERTISED)) {
                    c.add(BasePackFetchConnection.this.COMMON);
                }
                return !remoteKnowsIsCommon;
            }
        });
    }

    private void markRefsAdvertised() {
        for (Ref r : this.getRefs()) {
            this.markAdvertised(r.getObjectId());
            if (r.getPeeledObjectId() == null) continue;
            this.markAdvertised(r.getPeeledObjectId());
        }
    }

    private void markAdvertised(AnyObjectId id) {
        try {
            this.walk.parseAny(id).add(this.ADVERTISED);
        }
        catch (IOException iOException) {}
    }

    private void markCommon(RevObject obj, PacketLineIn.AckNackResult anr) throws IOException {
        if (this.statelessRPC && anr == PacketLineIn.AckNackResult.ACK_COMMON && !obj.has(this.STATE)) {
            StringBuilder s = new StringBuilder(46);
            s.append("have ");
            s.append(obj.name());
            s.append('\n');
            this.pckState.writeString(s.toString());
            obj.add(this.STATE);
        }
        obj.add(this.COMMON);
        if (obj instanceof RevCommit) {
            ((RevCommit)obj).carry(this.COMMON);
        }
    }

    private void receivePack(ProgressMonitor monitor) throws IOException {
        InputStream input = this.in;
        if (this.sideband) {
            input = new SideBandInputStream(input, monitor, this.getMessageWriter());
        }
        IndexPack ip = IndexPack.create(this.local, input);
        ip.setFixThin(this.thinPack);
        ip.setObjectChecking(this.transport.isCheckFetchedObjects());
        ip.index(monitor);
        this.packLock = ip.renameAndOpenPack(this.lockMessage);
    }

    private static class CancelledException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private CancelledException() {
        }
    }

    private static class FetchConfig {
        static final Config.SectionParser<FetchConfig> KEY = new Config.SectionParser<FetchConfig>(){

            @Override
            public FetchConfig parse(Config cfg) {
                return new FetchConfig(cfg);
            }
        };
        final boolean allowOfsDelta;

        FetchConfig(Config c) {
            this.allowOfsDelta = c.getBoolean("repack", "usedeltabaseoffset", true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MultiAck {
        OFF,
        CONTINUE,
        DETAILED;

    }
}

