/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.PackLock;
import org.eclipse.jgit.transport.IndexPack;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PostReceiveHook;
import org.eclipse.jgit.transport.PreReceiveHook;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivePack {
    private final Repository db;
    private final RevWalk walk;
    private boolean biDirectionalPipe = true;
    private boolean checkReceivedObjects;
    private boolean allowCreates;
    private boolean allowDeletes;
    private boolean allowNonFastForwards;
    private boolean allowOfsDelta;
    private PersonIdent refLogIdent;
    private RefFilter refFilter;
    private PreReceiveHook preReceive;
    private PostReceiveHook postReceive;
    private int timeout;
    private InterruptTimer timer;
    private TimeoutInputStream timeoutIn;
    private InputStream rawIn;
    private OutputStream rawOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private Writer msgs;
    private IndexPack ip;
    private Map<String, Ref> refs;
    private Set<String> enabledCapablities;
    private List<ReceiveCommand> commands;
    private StringBuilder advertiseError;
    private Throwable unpackError;
    private boolean reportStatus;
    private boolean sideBand;
    private PackLock packLock;
    private boolean checkReferencedIsReachable;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$transport$ReceiveCommand$Result;

    public ReceivePack(Repository into) {
        this.db = into;
        this.walk = new RevWalk(this.db);
        ReceiveConfig cfg = this.db.getConfig().get(ReceiveConfig.KEY);
        this.checkReceivedObjects = cfg.checkReceivedObjects;
        this.allowCreates = cfg.allowCreates;
        this.allowDeletes = cfg.allowDeletes;
        this.allowNonFastForwards = cfg.allowNonFastForwards;
        this.allowOfsDelta = cfg.allowOfsDelta;
        this.refFilter = RefFilter.DEFAULT;
        this.preReceive = PreReceiveHook.NULL;
        this.postReceive = PostReceiveHook.NULL;
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map<String, Ref> getAdvertisedRefs() {
        return this.refs;
    }

    public boolean isCheckReferencedObjectsAreReachable() {
        return this.checkReferencedIsReachable;
    }

    public void setCheckReferencedObjectsAreReachable(boolean b) {
        this.checkReferencedIsReachable = b;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean twoWay) {
        this.biDirectionalPipe = twoWay;
    }

    public boolean isCheckReceivedObjects() {
        return this.checkReceivedObjects;
    }

    public void setCheckReceivedObjects(boolean check) {
        this.checkReceivedObjects = check;
    }

    public boolean isAllowCreates() {
        return this.allowCreates;
    }

    public void setAllowCreates(boolean canCreate) {
        this.allowCreates = canCreate;
    }

    public boolean isAllowDeletes() {
        return this.allowDeletes;
    }

    public void setAllowDeletes(boolean canDelete) {
        this.allowDeletes = canDelete;
    }

    public boolean isAllowNonFastForwards() {
        return this.allowNonFastForwards;
    }

    public void setAllowNonFastForwards(boolean canRewind) {
        this.allowNonFastForwards = canRewind;
    }

    public PersonIdent getRefLogIdent() {
        return this.refLogIdent;
    }

    public void setRefLogIdent(PersonIdent pi) {
        this.refLogIdent = pi;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setRefFilter(RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public PreReceiveHook getPreReceiveHook() {
        return this.preReceive;
    }

    public void setPreReceiveHook(PreReceiveHook h) {
        this.preReceive = h != null ? h : PreReceiveHook.NULL;
    }

    public PostReceiveHook getPostReceiveHook() {
        return this.postReceive;
    }

    public void setPostReceiveHook(PostReceiveHook h) {
        this.postReceive = h != null ? h : PostReceiveHook.NULL;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public List<ReceiveCommand> getAllCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public void sendError(String what) {
        if (this.refs == null) {
            if (this.advertiseError == null) {
                this.advertiseError = new StringBuilder();
            }
            this.advertiseError.append(what).append('\n');
        } else {
            try {
                if (this.msgs != null) {
                    this.msgs.write("error: " + what + "\n");
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void sendMessage(String what) {
        try {
            if (this.msgs != null) {
                this.msgs.write(String.valueOf(what) + "\n");
            }
        }
        catch (IOException iOException) {}
    }

    public void receive(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        try {
            this.rawIn = input;
            this.rawOut = output;
            if (this.timeout > 0) {
                Thread caller = Thread.currentThread();
                this.timer = new InterruptTimer(String.valueOf(caller.getName()) + "-Timer");
                this.timeoutIn = new TimeoutInputStream(this.rawIn, this.timer);
                TimeoutOutputStream o = new TimeoutOutputStream(this.rawOut, this.timer);
                this.timeoutIn.setTimeout(this.timeout * 1000);
                o.setTimeout(this.timeout * 1000);
                this.rawIn = this.timeoutIn;
                this.rawOut = o;
            }
            this.pckIn = new PacketLineIn(this.rawIn);
            this.pckOut = new PacketLineOut(this.rawOut);
            if (messages != null) {
                this.msgs = new OutputStreamWriter(messages, Constants.CHARSET);
            }
            this.enabledCapablities = new HashSet<String>();
            this.commands = new ArrayList<ReceiveCommand>();
            this.service();
        }
        finally {
            this.walk.release();
            try {
                if (this.pckOut != null) {
                    this.pckOut.flush();
                }
                if (this.msgs != null) {
                    this.msgs.flush();
                }
                if (this.sideBand) {
                    new PacketLineOut(output).end();
                }
            }
            finally {
                this.unlockPack();
                this.timeoutIn = null;
                this.rawIn = null;
                this.rawOut = null;
                this.pckIn = null;
                this.pckOut = null;
                this.msgs = null;
                this.refs = null;
                this.enabledCapablities = null;
                this.commands = null;
                if (this.timer != null) {
                    try {
                        this.timer.terminate();
                    }
                    finally {
                        this.timer = null;
                    }
                }
            }
        }
    }

    private void service() throws IOException {
        if (this.biDirectionalPipe) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
        } else {
            this.refs = this.refFilter.filter(this.db.getAllRefs());
        }
        if (this.advertiseError != null) {
            return;
        }
        this.recvCommands();
        if (!this.commands.isEmpty()) {
            this.enableCapabilities();
            if (this.needPack()) {
                try {
                    this.receivePack();
                    if (this.needCheckConnectivity()) {
                        this.checkConnectivity();
                    }
                    this.ip = null;
                    this.unpackError = null;
                }
                catch (IOException err) {
                    this.unpackError = err;
                }
                catch (RuntimeException err) {
                    this.unpackError = err;
                }
                catch (Error err) {
                    this.unpackError = err;
                }
            }
            if (this.unpackError == null) {
                this.validateCommands();
                this.executeCommands();
            }
            this.unlockPack();
            if (this.reportStatus) {
                this.sendStatusReport(true, new Reporter(){

                    void sendString(String s) throws IOException {
                        ReceivePack.this.pckOut.writeString(String.valueOf(s) + "\n");
                    }
                });
                this.pckOut.end();
            } else if (this.msgs != null) {
                this.sendStatusReport(false, new Reporter(){

                    void sendString(String s) throws IOException {
                        ReceivePack.this.msgs.write(String.valueOf(s) + "\n");
                    }
                });
            }
            this.postReceive.onPostReceive(this, this.filterCommands(ReceiveCommand.Result.OK));
        }
    }

    private void unlockPack() {
        if (this.packLock != null) {
            this.packLock.unlock();
            this.packLock = null;
        }
    }

    public void sendAdvertisedRefs(RefAdvertiser adv) throws IOException {
        if (this.advertiseError != null) {
            adv.writeOne("ERR " + this.advertiseError);
            return;
        }
        RevFlag advertised = this.walk.newFlag("ADVERTISED");
        adv.init(this.walk, advertised);
        adv.advertiseCapability("side-band-64k");
        adv.advertiseCapability("delete-refs");
        adv.advertiseCapability("report-status");
        if (this.allowOfsDelta) {
            adv.advertiseCapability("ofs-delta");
        }
        this.refs = this.refFilter.filter(this.db.getAllRefs());
        Ref head = this.refs.remove("HEAD");
        adv.send(this.refs);
        if (head != null && !head.isSymbolic()) {
            adv.advertiseHave(head.getObjectId());
        }
        adv.includeAdditionalHaves(this.db);
        if (adv.isEmpty()) {
            adv.advertiseId(ObjectId.zeroId(), "capabilities^{}");
        }
        adv.end();
    }

    private void recvCommands() throws IOException {
        while (true) {
            int nul;
            String line;
            try {
                line = this.pckIn.readStringRaw();
            }
            catch (EOFException eof) {
                if (this.commands.isEmpty()) {
                    return;
                }
                throw eof;
            }
            if (line == PacketLineIn.END) break;
            if (this.commands.isEmpty() && (nul = line.indexOf(0)) >= 0) {
                String[] stringArray = line.substring(nul + 1).split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    this.enabledCapablities.add(c);
                    ++n2;
                }
                line = line.substring(0, nul);
            }
            if (line.length() < 83) {
                String m = JGitText.get().errorInvalidProtocolWantedOldNewRef;
                this.sendError(m);
                throw new PackProtocolException(m);
            }
            ObjectId oldId = ObjectId.fromString(line.substring(0, 40));
            ObjectId newId = ObjectId.fromString(line.substring(41, 81));
            String name = line.substring(82);
            ReceiveCommand cmd = new ReceiveCommand(oldId, newId, name);
            if (name.equals("HEAD")) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_CURRENT_BRANCH);
            } else {
                cmd.setRef(this.refs.get(cmd.getRefName()));
            }
            this.commands.add(cmd);
        }
    }

    private void enableCapabilities() {
        this.reportStatus = this.enabledCapablities.contains("report-status");
        this.sideBand = this.enabledCapablities.contains("side-band-64k");
        if (this.sideBand) {
            OutputStream out = this.rawOut;
            this.rawOut = new SideBandOutputStream(1, 65520, out);
            this.pckOut = new PacketLineOut(this.rawOut);
            this.msgs = new OutputStreamWriter((OutputStream)new SideBandOutputStream(2, 65520, out), Constants.CHARSET);
        }
    }

    private boolean needPack() {
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getType() == ReceiveCommand.Type.DELETE) continue;
            return true;
        }
        return false;
    }

    private void receivePack() throws IOException {
        if (this.timeoutIn != null) {
            this.timeoutIn.setTimeout(10 * this.timeout * 1000);
        }
        this.ip = IndexPack.create(this.db, this.rawIn);
        this.ip.setFixThin(true);
        this.ip.setNeedNewObjectIds(this.checkReferencedIsReachable);
        this.ip.setNeedBaseObjectIds(this.checkReferencedIsReachable);
        this.ip.setObjectChecking(this.isCheckReceivedObjects());
        this.ip.index(NullProgressMonitor.INSTANCE);
        String lockMsg = "jgit receive-pack";
        if (this.getRefLogIdent() != null) {
            lockMsg = String.valueOf(lockMsg) + " from " + this.getRefLogIdent().toExternalString();
        }
        this.packLock = this.ip.renameAndOpenPack(lockMsg);
        if (this.timeoutIn != null) {
            this.timeoutIn.setTimeout(this.timeout * 1000);
        }
    }

    private boolean needCheckConnectivity() {
        return this.isCheckReceivedObjects() || this.isCheckReferencedObjectsAreReachable();
    }

    private void checkConnectivity() throws IOException {
        RevObject o;
        RevCommit c;
        ObjectIdSubclassMap<ObjectId> baseObjects = null;
        ObjectIdSubclassMap<ObjectId> providedObjects = null;
        if (this.checkReferencedIsReachable) {
            baseObjects = this.ip.getBaseObjectIds();
            providedObjects = this.ip.getNewObjectIds();
        }
        this.ip = null;
        ObjectWalk ow = new ObjectWalk(this.db);
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || cmd.getType() == ReceiveCommand.Type.DELETE) continue;
            ow.markStart(ow.parseAny(cmd.getNewId()));
        }
        for (Ref ref : this.refs.values()) {
            RevObject o2 = ow.parseAny(ref.getObjectId());
            ow.markUninteresting(o2);
            if (!this.checkReferencedIsReachable || baseObjects.isEmpty()) continue;
            if ((o2 = ow.peel(o2)) instanceof RevCommit) {
                o2 = ((RevCommit)o2).getTree();
            }
            if (!(o2 instanceof RevTree)) continue;
            ow.markUninteresting(o2);
        }
        if (this.checkReferencedIsReachable) {
            for (ObjectId id : baseObjects) {
                RevObject b = ow.lookupAny(id, 3);
                if (b.has(RevFlag.UNINTERESTING)) continue;
                throw new MissingObjectException((ObjectId)b, b.getType());
            }
        }
        while ((c = ow.next()) != null) {
            if (!this.checkReferencedIsReachable || providedObjects.contains(c)) continue;
            throw new MissingObjectException((ObjectId)c, "commit");
        }
        while ((o = ow.nextObject()) != null) {
            if (this.checkReferencedIsReachable) {
                if (providedObjects.contains(o)) continue;
                throw new MissingObjectException((ObjectId)o, o.getType());
            }
            if (!(o instanceof RevBlob) || this.db.hasObject(o)) continue;
            throw new MissingObjectException((ObjectId)o, "blob");
        }
    }

    private void validateCommands() {
        for (ReceiveCommand cmd : this.commands) {
            Ref ref = cmd.getRef();
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            if (cmd.getType() == ReceiveCommand.Type.DELETE && !this.isAllowDeletes()) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_NODELETE);
                continue;
            }
            if (cmd.getType() == ReceiveCommand.Type.CREATE) {
                if (!this.isAllowCreates()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NOCREATE);
                    continue;
                }
                if (ref != null && !this.isAllowNonFastForwards()) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                    continue;
                }
                if (ref != null) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "ref exists");
                    continue;
                }
            }
            if (cmd.getType() == ReceiveCommand.Type.DELETE && ref != null && !ObjectId.zeroId().equals(cmd.getOldId()) && !ref.getObjectId().equals(cmd.getOldId())) {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().invalidOldIdSent);
                continue;
            }
            if (cmd.getType() == ReceiveCommand.Type.UPDATE) {
                RevObject newObj;
                RevObject oldObj;
                if (ref == null) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().noSuchRef);
                    continue;
                }
                if (!ref.getObjectId().equals(cmd.getOldId())) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().invalidOldIdSent);
                    continue;
                }
                try {
                    oldObj = this.walk.parseAny(cmd.getOldId());
                }
                catch (IOException iOException) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getOldId().name());
                    continue;
                }
                try {
                    newObj = this.walk.parseAny(cmd.getNewId());
                }
                catch (IOException iOException) {
                    cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getNewId().name());
                    continue;
                }
                if (oldObj instanceof RevCommit && newObj instanceof RevCommit) {
                    try {
                        if (!this.walk.isMergedInto((RevCommit)oldObj, (RevCommit)newObj)) {
                            cmd.setType(ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
                        }
                    }
                    catch (MissingObjectException e) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, e.getMessage());
                    }
                    catch (IOException iOException) {
                        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON);
                    }
                } else {
                    cmd.setType(ReceiveCommand.Type.UPDATE_NONFASTFORWARD);
                }
            }
            if (cmd.getRefName().startsWith("refs/") && Repository.isValidRefName(cmd.getRefName())) continue;
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().funnyRefname);
        }
    }

    private void executeCommands() {
        this.preReceive.onPreReceive(this, this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED));
        for (ReceiveCommand cmd : this.filterCommands(ReceiveCommand.Result.NOT_ATTEMPTED)) {
            this.execute(cmd);
        }
    }

    private void execute(ReceiveCommand cmd) {
        try {
            RefUpdate ru = this.db.updateRef(cmd.getRefName());
            ru.setRefLogIdent(this.getRefLogIdent());
            switch (cmd.getType()) {
                case DELETE: {
                    if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                        ru.setExpectedOldObjectId(cmd.getOldId());
                    }
                    ru.setForceUpdate(true);
                    this.status(cmd, ru.delete(this.walk));
                    break;
                }
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    ru.setForceUpdate(this.isAllowNonFastForwards());
                    ru.setExpectedOldObjectId(cmd.getOldId());
                    ru.setNewObjectId(cmd.getNewId());
                    ru.setRefLogMessage("push", true);
                    this.status(cmd, ru.update(this.walk));
                }
            }
        }
        catch (IOException err) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err.getMessage()));
        }
    }

    private void status(ReceiveCommand cmd, RefUpdate.Result result) {
        switch (result) {
            case NOT_ATTEMPTED: {
                cmd.setResult(ReceiveCommand.Result.NOT_ATTEMPTED);
                break;
            }
            case LOCK_FAILURE: 
            case IO_FAILURE: {
                cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                break;
            }
            case NO_CHANGE: 
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                cmd.setResult(ReceiveCommand.Result.OK);
                break;
            }
            case REJECTED: {
                cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                break;
            }
            case REJECTED_CURRENT_BRANCH: {
                cmd.setResult(ReceiveCommand.Result.REJECTED_CURRENT_BRANCH);
                break;
            }
            default: {
                cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, result.name());
            }
        }
    }

    private List<ReceiveCommand> filterCommands(ReceiveCommand.Result want) {
        ArrayList<ReceiveCommand> r = new ArrayList<ReceiveCommand>(this.commands.size());
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() != want) continue;
            r.add(cmd);
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    private void sendStatusReport(boolean forClient, Reporter out) throws IOException {
        if (this.unpackError != null) {
            out.sendString(MessageFormat.format(JGitText.get().unpackError, new Object[]{this.unpackError.getMessage()}));
            if (forClient) {
                for (ReceiveCommand cmd : this.commands) {
                    out.sendString("ng " + cmd.getRefName() + " n/a (unpacker error)");
                }
            }
            return;
        }
        if (forClient) {
            out.sendString("unpack ok");
        }
        for (ReceiveCommand cmd : this.commands) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) {
                if (!forClient) continue;
                out.sendString("ok " + cmd.getRefName());
                continue;
            }
            r = new StringBuilder();
            r.append("ng ");
            r.append(cmd.getRefName());
            r.append(" ");
            switch (ReceivePack.$SWITCH_TABLE$org$eclipse$jgit$transport$ReceiveCommand$Result()[cmd.getResult().ordinal()]) {
                case 1: {
                    r.append("server bug; ref not processed");
                    ** GOTO lbl69
                }
                case 2: {
                    r.append("creation prohibited");
                    ** GOTO lbl69
                }
                case 3: {
                    r.append("deletion prohibited");
                    ** GOTO lbl69
                }
                case 4: {
                    r.append("non-fast forward");
                    ** GOTO lbl69
                }
                case 5: {
                    r.append("branch is currently checked out");
                    ** GOTO lbl69
                }
                case 6: {
                    if (cmd.getMessage() == null) {
                        r.append("missing object(s)");
                    } else if (cmd.getMessage().length() == 40) {
                        r.append("object " + cmd.getMessage() + " missing");
                    } else {
                        r.append(cmd.getMessage());
                    }
                    ** GOTO lbl69
                }
                case 7: {
                    if (cmd.getMessage() == null) {
                        r.append("unspecified reason");
                    } else {
                        r.append(cmd.getMessage());
                    }
                    ** GOTO lbl69
                }
                case 8: {
                    r.append("failed to lock");
                    ** GOTO lbl69
                }
                case 9: {
                    break;
                }
lbl69:
                // 12 sources

                default: {
                    out.sendString(r.toString());
                }
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$transport$ReceiveCommand$Result() {
        if ($SWITCH_TABLE$org$eclipse$jgit$transport$ReceiveCommand$Result != null) {
            return $SWITCH_TABLE$org$eclipse$jgit$transport$ReceiveCommand$Result;
        }
        int[] nArray = new int[ReceiveCommand.Result.values().length];
        try {
            nArray[ReceiveCommand.Result.LOCK_FAILURE.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.NOT_ATTEMPTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.OK.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.REJECTED_CURRENT_BRANCH.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.REJECTED_MISSING_OBJECT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.REJECTED_NOCREATE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.REJECTED_NODELETE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.REJECTED_NONFASTFORWARD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReceiveCommand.Result.REJECTED_OTHER_REASON.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jgit$transport$ReceiveCommand$Result = nArray;
        return nArray;
    }

    private static class ReceiveConfig {
        static final Config.SectionParser<ReceiveConfig> KEY = new Config.SectionParser<ReceiveConfig>(){

            @Override
            public ReceiveConfig parse(Config cfg) {
                return new ReceiveConfig(cfg);
            }
        };
        final boolean checkReceivedObjects;
        final boolean allowCreates;
        final boolean allowDeletes;
        final boolean allowNonFastForwards;
        final boolean allowOfsDelta;

        ReceiveConfig(Config config) {
            this.checkReceivedObjects = config.getBoolean("receive", "fsckobjects", false);
            this.allowCreates = true;
            this.allowDeletes = !config.getBoolean("receive", "denydeletes", false);
            this.allowNonFastForwards = !config.getBoolean("receive", "denynonfastforwards", false);
            this.allowOfsDelta = config.getBoolean("repack", "usedeltabaseoffset", true);
        }
    }

    static abstract class Reporter {
        Reporter() {
        }

        abstract void sendString(String var1) throws IOException;
    }
}

