/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.eclipse.jgit.util.io.UnionInputStream;

public class TransportHttp
extends HttpTransport
implements WalkTransport,
PackTransport {
    private static final String SVC_UPLOAD_PACK = "git-upload-pack";
    private static final String SVC_RECEIVE_PACK = "git-receive-pack";
    private static final String userAgent = TransportHttp.computeUserAgent();
    private static final Config.SectionParser<HttpConfig> HTTP_KEY = new Config.SectionParser<HttpConfig>(){

        @Override
        public HttpConfig parse(Config cfg) {
            return new HttpConfig(cfg);
        }
    };
    private final URL baseUrl;
    private final URL objectsUrl;
    private final HttpConfig http;
    private final ProxySelector proxySelector;
    private boolean useSmartHttp = true;

    static boolean canHandle(URIish uri) {
        if (!uri.isRemote()) {
            return false;
        }
        String s = uri.getScheme();
        return "http".equals(s) || "https".equals(s) || "ftp".equals(s);
    }

    private static String computeUserAgent() {
        Package pkg = TransportHttp.class.getPackage();
        String version = pkg != null && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : "unknown";
        return "JGit/" + version;
    }

    TransportHttp(Repository local, URIish uri) throws NotSupportedException {
        super(local, uri);
        try {
            String uriString = uri.toString();
            if (!uriString.endsWith("/")) {
                uriString = String.valueOf(uriString) + "/";
            }
            this.baseUrl = new URL(uriString);
            this.objectsUrl = new URL(this.baseUrl, "objects/");
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, uri), e);
        }
        this.http = local.getConfig().get(HTTP_KEY);
        this.proxySelector = ProxySelector.getDefault();
    }

    public void setUseSmartHttp(boolean on) {
        this.useSmartHttp = on;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FetchConnection openFetch() throws TransportException, NotSupportedException {
        try {
            HttpURLConnection c = this.connect(SVC_UPLOAD_PACK);
            InputStream in = this.openInputStream(c);
            try {
                if (this.isSmartHttp(c, SVC_UPLOAD_PACK)) {
                    this.readSmartHeaders(in, SVC_UPLOAD_PACK);
                    SmartHttpFetchConnection smartHttpFetchConnection = new SmartHttpFetchConnection(in);
                    return smartHttpFetchConnection;
                }
                FetchConnection fetchConnection = this.newDumbConnection(in);
                return fetchConnection;
            }
            finally {
                in.close();
            }
        }
        catch (NotSupportedException err) {
            throw err;
        }
        catch (TransportException err) {
            throw err;
        }
        catch (IOException err) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, err);
        }
    }

    private FetchConnection newDumbConnection(InputStream in) throws IOException, PackProtocolException {
        Map<String, Ref> refs;
        HttpObjectDB d = new HttpObjectDB(this.objectsUrl);
        BufferedReader br = this.toBufferedReader(in);
        try {
            refs = d.readAdvertisedImpl(br);
        }
        finally {
            br.close();
        }
        if (!refs.containsKey("HEAD")) {
            HttpURLConnection conn = this.httpOpen(new URL(this.baseUrl, "HEAD"));
            int status = HttpSupport.response(conn);
            switch (status) {
                case 200: {
                    br = this.toBufferedReader(this.openInputStream(conn));
                    try {
                        String line = br.readLine();
                        if (line != null && line.startsWith("ref: ")) {
                            String target = line.substring("ref: ".length());
                            Ref r = refs.get(target);
                            if (r == null) {
                                r = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
                            }
                            r = new SymbolicRef("HEAD", r);
                            refs.put(r.getName(), r);
                            break;
                        }
                        if (line == null || !ObjectId.isId(line)) break;
                        ObjectIdRef.Unpeeled r = new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, "HEAD", ObjectId.fromString(line));
                        refs.put(r.getName(), r);
                        break;
                    }
                    finally {
                        br.close();
                    }
                }
                case 404: {
                    break;
                }
                default: {
                    throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotReadHEAD, status, conn.getResponseMessage()));
                }
            }
        }
        WalkFetchConnection wfc = new WalkFetchConnection(this, d);
        wfc.available(refs);
        return wfc;
    }

    private BufferedReader toBufferedReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, Constants.CHARSET));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PushConnection openPush() throws NotSupportedException, TransportException {
        try {
            HttpURLConnection c = this.connect(SVC_RECEIVE_PACK);
            InputStream in = this.openInputStream(c);
            try {
                if (this.isSmartHttp(c, SVC_RECEIVE_PACK)) {
                    this.readSmartHeaders(in, SVC_RECEIVE_PACK);
                    SmartHttpPushConnection smartHttpPushConnection = new SmartHttpPushConnection(in);
                    return smartHttpPushConnection;
                }
                if (!this.useSmartHttp) {
                    String msg = JGitText.get().smartHTTPPushDisabled;
                    throw new NotSupportedException(msg);
                }
                String msg = JGitText.get().remoteDoesNotSupportSmartHTTPPush;
                throw new NotSupportedException(msg);
            }
            finally {
                in.close();
            }
        }
        catch (NotSupportedException err) {
            throw err;
        }
        catch (TransportException err) {
            throw err;
        }
        catch (IOException err) {
            throw new TransportException(this.uri, JGitText.get().errorReadingInfoRefs, err);
        }
    }

    public void close() {
    }

    private HttpURLConnection connect(String service) throws TransportException, NotSupportedException {
        URL u;
        try {
            StringBuilder b = new StringBuilder();
            b.append(this.baseUrl);
            if (b.charAt(b.length() - 1) != '/') {
                b.append('/');
            }
            b.append("info/refs");
            if (this.useSmartHttp) {
                b.append(b.indexOf("?") < 0 ? (char)'?' : '&');
                b.append("service=");
                b.append(service);
            }
            u = new URL(b.toString());
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().invalidURL, this.uri), e);
        }
        try {
            HttpURLConnection conn = this.httpOpen(u);
            if (this.useSmartHttp) {
                String expType = "application/x-" + service + "-advertisement";
                conn.setRequestProperty("Accept", String.valueOf(expType) + ", */*");
            } else {
                conn.setRequestProperty("Accept", "*/*");
            }
            int status = HttpSupport.response(conn);
            switch (status) {
                case 200: {
                    return conn;
                }
                case 404: {
                    throw new NoRemoteRepositoryException(this.uri, MessageFormat.format(JGitText.get().URLNotFound, u));
                }
                case 403: {
                    throw new TransportException(this.uri, MessageFormat.format(JGitText.get().serviceNotPermitted, service));
                }
            }
            String err = String.valueOf(status) + " " + conn.getResponseMessage();
            throw new TransportException(this.uri, err);
        }
        catch (NotSupportedException e) {
            throw e;
        }
        catch (TransportException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().cannotOpenService, service), e);
        }
    }

    final HttpURLConnection httpOpen(URL u) throws IOException {
        Proxy proxy = HttpSupport.proxyFor(this.proxySelector, u);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection(proxy);
        conn.setUseCaches(false);
        conn.setRequestProperty("Accept-Encoding", "gzip");
        conn.setRequestProperty("Pragma", "no-cache");
        conn.setRequestProperty("User-Agent", userAgent);
        return conn;
    }

    final InputStream openInputStream(HttpURLConnection conn) throws IOException {
        InputStream input = conn.getInputStream();
        if ("gzip".equals(conn.getHeaderField("Content-Encoding"))) {
            input = new GZIPInputStream(input);
        }
        return input;
    }

    IOException wrongContentType(String expType, String actType) {
        String why = MessageFormat.format(JGitText.get().expectedReceivedContentType, expType, actType);
        return new TransportException(this.uri, why);
    }

    private boolean isSmartHttp(HttpURLConnection c, String service) {
        String expType = "application/x-" + service + "-advertisement";
        String actType = c.getContentType();
        return expType.equals(actType);
    }

    private void readSmartHeaders(InputStream in, String service) throws IOException {
        String act;
        byte[] magic = new byte[5];
        IO.readFully(in, magic, 0, magic.length);
        if (magic[4] != 35) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedPktLineWithService, RawParseUtils.decode(magic)));
        }
        PacketLineIn pckIn = new PacketLineIn(new UnionInputStream(new ByteArrayInputStream(magic), in));
        String exp = "# service=" + service;
        if (!exp.equals(act = pckIn.readString())) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedGot, exp, act));
        }
        while (pckIn.readString() != PacketLineIn.END) {
        }
    }

    private static class HttpConfig {
        final int postBuffer;

        HttpConfig(Config rc) {
            this.postBuffer = rc.getInt("http", "postbuffer", 0x100000);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpObjectDB
    extends WalkRemoteObjectDatabase {
        private final URL objectsUrl;

        HttpObjectDB(URL b) {
            this.objectsUrl = b;
        }

        @Override
        URIish getURI() {
            return new URIish(this.objectsUrl);
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/http-alternates");
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    return this.readAlternates("info/alternates");
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    return null;
                }
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new HttpObjectDB(new URL(this.objectsUrl, location));
        }

        @Override
        Collection<String> getPackNames() throws IOException {
            ArrayList<String> arrayList;
            ArrayList<String> packs = new ArrayList<String>();
            BufferedReader br = this.openReader("info/packs");
            try {
                String s;
                while ((s = br.readLine()) != null && s.length() != 0) {
                    if (!s.startsWith("P pack-") || !s.endsWith(".pack")) {
                        throw this.invalidAdvertisement(s);
                    }
                    packs.add(s.substring(2));
                }
                arrayList = packs;
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return packs;
                }
            }
            br.close();
            return arrayList;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path) throws IOException {
            URL base = this.objectsUrl;
            URL u = new URL(base, path);
            HttpURLConnection c = TransportHttp.this.httpOpen(u);
            switch (HttpSupport.response(c)) {
                case 200: {
                    InputStream in = TransportHttp.this.openInputStream(c);
                    int len = c.getContentLength();
                    return new WalkRemoteObjectDatabase.FileStream(in, len);
                }
                case 404: {
                    throw new FileNotFoundException(u.toString());
                }
            }
            throw new IOException(String.valueOf(u.toString()) + ": " + HttpSupport.response(c) + " " + c.getResponseMessage());
        }

        Map<String, Ref> readAdvertisedImpl(BufferedReader br) throws IOException, PackProtocolException {
            String line;
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            while ((line = br.readLine()) != null) {
                Ref prior;
                int tab = line.indexOf(9);
                if (tab < 0) {
                    throw this.invalidAdvertisement(line);
                }
                String name = line.substring(tab + 1);
                ObjectId id = ObjectId.fromString(line.substring(0, tab));
                if (name.endsWith("^{}")) {
                    prior = avail.get(name = name.substring(0, name.length() - 3));
                    if (prior == null) {
                        throw this.outOfOrderAdvertisement(name);
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(String.valueOf(name) + "^{}");
                    }
                    avail.put(name, new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, prior.getObjectId(), id));
                    continue;
                }
                prior = avail.put(name, new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id));
                if (prior == null) continue;
                throw this.duplicateAdvertisement(name);
            }
            return avail;
        }

        private PackProtocolException outOfOrderAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().advertisementOfCameBefore, n, n));
        }

        private PackProtocolException invalidAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().invalidAdvertisementOf, n));
        }

        private PackProtocolException duplicateAdvertisement(String n) {
            return new PackProtocolException(MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, n));
        }

        @Override
        void close() {
        }
    }

    class Service {
        private final String serviceName;
        private final String requestType;
        private final String responseType;
        private final HttpExecuteStream execute;
        final UnionInputStream in;
        final HttpOutputStream out;
        HttpURLConnection conn;

        Service(String serviceName) {
            this.serviceName = serviceName;
            this.requestType = "application/x-" + serviceName + "-request";
            this.responseType = "application/x-" + serviceName + "-result";
            this.execute = new HttpExecuteStream();
            this.in = new UnionInputStream(this.execute);
            this.out = new HttpOutputStream();
        }

        void openStream() throws IOException {
            this.conn = TransportHttp.this.httpOpen(new URL(TransportHttp.this.baseUrl, this.serviceName));
            this.conn.setRequestMethod("POST");
            this.conn.setInstanceFollowRedirects(false);
            this.conn.setDoOutput(true);
            this.conn.setRequestProperty("Content-Type", this.requestType);
            this.conn.setRequestProperty("Accept", this.responseType);
        }

        void execute() throws IOException {
            this.out.close();
            if (this.conn == null) {
                if (this.out.length() == 0L) {
                    throw new TransportException(TransportHttp.this.uri, JGitText.get().startingReadStageWithoutWrittenRequestDataPendingIsNotSupported);
                }
                TemporaryBuffer buf = new TemporaryBuffer.Heap(((TransportHttp)TransportHttp.this).http.postBuffer);
                try {
                    GZIPOutputStream gzip = new GZIPOutputStream(buf);
                    this.out.writeTo(gzip, null);
                    gzip.close();
                    if (this.out.length() < buf.length()) {
                        buf = this.out;
                    }
                }
                catch (IOException iOException) {
                    buf = this.out;
                }
                this.openStream();
                if (buf != this.out) {
                    this.conn.setRequestProperty("Content-Encoding", "gzip");
                }
                this.conn.setFixedLengthStreamingMode((int)buf.length());
                OutputStream httpOut = this.conn.getOutputStream();
                try {
                    buf.writeTo(httpOut, null);
                }
                finally {
                    httpOut.close();
                }
            }
            this.out.reset();
            int status = HttpSupport.response(this.conn);
            if (status != 200) {
                throw new TransportException(TransportHttp.this.uri, String.valueOf(status) + " " + this.conn.getResponseMessage());
            }
            String contentType = this.conn.getContentType();
            if (!this.responseType.equals(contentType)) {
                this.conn.getInputStream().close();
                throw TransportHttp.this.wrongContentType(this.responseType, contentType);
            }
            this.in.add(TransportHttp.this.openInputStream(this.conn));
            this.in.add(this.execute);
            this.conn = null;
        }

        class HttpExecuteStream
        extends InputStream {
            HttpExecuteStream() {
            }

            public int available() throws IOException {
                Service.this.execute();
                return 0;
            }

            public int read() throws IOException {
                Service.this.execute();
                return -1;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                Service.this.execute();
                return -1;
            }

            public long skip(long n) throws IOException {
                Service.this.execute();
                return 0L;
            }
        }

        class HttpOutputStream
        extends TemporaryBuffer {
            HttpOutputStream() {
                super(((TransportHttp)((Service)Service.this).TransportHttp.this).http.postBuffer);
            }

            protected OutputStream overflow() throws IOException {
                Service.this.openStream();
                Service.this.conn.setChunkedStreamingMode(0);
                return Service.this.conn.getOutputStream();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SmartHttpFetchConnection
    extends BasePackFetchConnection {
        SmartHttpFetchConnection(InputStream advertisement) throws TransportException {
            super(TransportHttp.this);
            this.statelessRPC = true;
            this.init(advertisement, DisabledOutputStream.INSTANCE);
            this.outNeedsEnd = false;
            this.readAdvertisedRefs();
        }

        @Override
        protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
            Service svc = new Service(TransportHttp.SVC_UPLOAD_PACK);
            this.init(svc.in, svc.out);
            super.doFetch(monitor, want, have);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SmartHttpPushConnection
    extends BasePackPushConnection {
        SmartHttpPushConnection(InputStream advertisement) throws TransportException {
            super(TransportHttp.this);
            this.statelessRPC = true;
            this.init(advertisement, DisabledOutputStream.INSTANCE);
            this.outNeedsEnd = false;
            this.readAdvertisedRefs();
        }

        @Override
        protected void doPush(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates) throws TransportException {
            Service svc = new Service(TransportHttp.SVC_RECEIVE_PACK);
            this.init(svc.in, svc.out);
            super.doPush(monitor, refUpdates);
        }
    }
}

