/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeWalk {
    private final ObjectReader reader;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private TreeFilter filter;
    AbstractTreeIterator[] trees;
    private boolean recursive;
    private boolean postOrderTraversal;
    private int depth;
    private boolean advance;
    private boolean postChildren;
    AbstractTreeIterator currentHead;

    public static TreeWalk forPath(ObjectReader reader, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk r = new TreeWalk(reader);
        r.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(path)));
        r.setRecursive(r.getFilter().shouldBeRecursive());
        r.reset(trees);
        return r.next() ? r : null;
    }

    public static TreeWalk forPath(Repository db, String path, AnyObjectId ... trees) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        ObjectReader reader = db.newObjectReader();
        try {
            TreeWalk treeWalk = TreeWalk.forPath(reader, path, trees);
            return treeWalk;
        }
        finally {
            reader.release();
        }
    }

    public static TreeWalk forPath(Repository db, String path, RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return TreeWalk.forPath(db, path, (AnyObjectId[])new ObjectId[]{tree});
    }

    public TreeWalk(Repository repo) {
        this(repo.newObjectReader());
    }

    public TreeWalk(ObjectReader or) {
        this.reader = or;
        this.filter = TreeFilter.ALL;
        this.trees = new AbstractTreeIterator[]{new EmptyTreeIterator()};
    }

    public ObjectReader getObjectReader() {
        return this.reader;
    }

    public void release() {
        this.reader.release();
    }

    public TreeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeFilter newFilter) {
        this.filter = newFilter != null ? newFilter : TreeFilter.ALL;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean b) {
        this.recursive = b;
    }

    public boolean isPostOrderTraversal() {
        return this.postOrderTraversal;
    }

    public void setPostOrderTraversal(boolean b) {
        this.postOrderTraversal = b;
    }

    public void reset() {
        this.trees = new AbstractTreeIterator[0];
        this.advance = false;
        this.depth = 0;
    }

    public void reset(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        if (this.trees.length == 1) {
            AbstractTreeIterator o = this.trees[0];
            while (o.parent != null) {
                o = o.parent;
            }
            if (o instanceof CanonicalTreeParser) {
                o.matches = null;
                o.matchShift = 0;
                ((CanonicalTreeParser)o).reset(this.reader, id);
                this.trees[0] = o;
            } else {
                this.trees[0] = this.parserFor(id);
            }
        } else {
            this.trees = new AbstractTreeIterator[]{this.parserFor(id)};
        }
        this.advance = false;
        this.depth = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void reset(AnyObjectId[] ids) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        newLen = ids.length;
        oldLen = this.trees.length;
        r = newLen == oldLen ? this.trees : new AbstractTreeIterator[newLen];
        i = 0;
        while (i < newLen) {
            if (i >= oldLen) ** GOTO lbl-1000
            o = this.trees[i];
            while (o.parent != null) {
                o = o.parent;
            }
            if (o instanceof CanonicalTreeParser && o.pathOffset == 0) {
                o.matches = null;
                o.matchShift = 0;
                ((CanonicalTreeParser)o).reset(this.reader, ids[i]);
                r[i] = o;
            } else lbl-1000:
            // 2 sources

            {
                r[i] = o = this.parserFor(ids[i]);
            }
            ++i;
        }
        this.trees = r;
        this.advance = false;
        this.depth = 0;
    }

    public int addTree(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return this.addTree(this.parserFor(id));
    }

    public int addTree(AbstractTreeIterator p) throws CorruptObjectException {
        int n = this.trees.length;
        AbstractTreeIterator[] newTrees = new AbstractTreeIterator[n + 1];
        System.arraycopy(this.trees, 0, newTrees, 0, n);
        newTrees[n] = p;
        p.matches = null;
        p.matchShift = 0;
        this.trees = newTrees;
        return n;
    }

    public int getTreeCount() {
        return this.trees.length;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        try {
            if (this.advance) {
                this.advance = false;
                this.postChildren = false;
                this.popEntriesEqual();
            }
            while (true) {
                if ((t = this.min()).eof()) {
                    if (this.depth <= 0) {
                        return false;
                    }
                    this.exitSubtree();
                    if (this.postOrderTraversal) {
                        this.advance = true;
                        this.postChildren = true;
                        return true;
                    }
                    this.popEntriesEqual();
                    continue;
                }
                this.currentHead = t;
                if (!this.filter.include(this)) {
                    this.skipEntriesEqual();
                    continue;
                }
                if (!this.recursive || !FileMode.TREE.equals(t.mode)) break;
                this.enterSubtree();
            }
            this.advance = true;
            return true;
        }
        catch (StopWalkException v0) {
            var4_3 = this.trees;
            var3_4 = this.trees.length;
            var2_5 = 0;
            ** while (var2_5 < var3_4)
        }
lbl-1000:
        // 1 sources

        {
            t = var4_3[var2_5];
            t.stopWalk();
            ++var2_5;
            continue;
        }
lbl35:
        // 1 sources

        return false;
    }

    public <T extends AbstractTreeIterator> T getTree(int nth, Class<T> clazz) {
        AbstractTreeIterator t = this.trees[nth];
        return (T)(t.matches == this.currentHead ? t : null);
    }

    public int getRawMode(int nth) {
        AbstractTreeIterator t = this.trees[nth];
        return t.matches == this.currentHead ? t.mode : 0;
    }

    public FileMode getFileMode(int nth) {
        return FileMode.fromBits(this.getRawMode(nth));
    }

    public ObjectId getObjectId(int nth) {
        AbstractTreeIterator t = this.trees[nth];
        return t.matches == this.currentHead ? t.getEntryObjectId() : ObjectId.zeroId();
    }

    public void getObjectId(MutableObjectId out, int nth) {
        AbstractTreeIterator t = this.trees[nth];
        if (t.matches == this.currentHead) {
            t.getEntryObjectId(out);
        } else {
            out.clear();
        }
    }

    public boolean idEqual(int nthA, int nthB) {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator a = this.trees[nthA];
        AbstractTreeIterator b = this.trees[nthB];
        if (a.matches == ch && b.matches == ch) {
            return a.idEqual(b);
        }
        return a.matches != ch && b.matches != ch;
    }

    public String getNameString() {
        AbstractTreeIterator t = this.currentHead;
        int off = t.pathOffset;
        int end = t.pathLen;
        return RawParseUtils.decode(Constants.CHARSET, t.path, off, end);
    }

    public String getPathString() {
        return TreeWalk.pathOf(this.currentHead);
    }

    public byte[] getRawPath() {
        AbstractTreeIterator t = this.currentHead;
        int n = t.pathLen;
        byte[] r = new byte[n];
        System.arraycopy(t.path, 0, r, 0, n);
        return r;
    }

    public int isPathPrefix(byte[] p, int pLen) {
        AbstractTreeIterator t = this.currentHead;
        byte[] c = t.path;
        int cLen = t.pathLen;
        int ci = 0;
        while (ci < cLen && ci < pLen) {
            int c_value = (c[ci] & 0xFF) - (p[ci] & 0xFF);
            if (c_value != 0) {
                return c_value;
            }
            ++ci;
        }
        if (ci < cLen) {
            return c[ci] == 47 ? 0 : -1;
        }
        if (ci < pLen) {
            return p[ci] == 47 ? 0 : -1;
        }
        return 0;
    }

    public boolean isPathSuffix(byte[] p, int pLen) {
        AbstractTreeIterator t = this.currentHead;
        byte[] c = t.path;
        int cLen = t.pathLen;
        int ci = 1;
        while (ci < cLen && ci < pLen) {
            if (c[cLen - ci] != p[pLen - ci]) {
                return false;
            }
            ++ci;
        }
        return true;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isSubtree() {
        return FileMode.TREE.equals(this.currentHead.mode);
    }

    public boolean isPostChildren() {
        return this.postChildren && this.isSubtree();
    }

    public void enterSubtree() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        AbstractTreeIterator ch = this.currentHead;
        AbstractTreeIterator[] tmp = new AbstractTreeIterator[this.trees.length];
        int i = 0;
        while (i < this.trees.length) {
            AbstractTreeIterator t = this.trees[i];
            AbstractTreeIterator n = t.matches == ch && !t.eof() && FileMode.TREE.equals(t.mode) ? t.createSubtreeIterator(this.reader, this.idBuffer) : t.createEmptyTreeIterator();
            tmp[i] = n;
            ++i;
        }
        ++this.depth;
        this.advance = false;
        System.arraycopy(tmp, 0, this.trees, 0, this.trees.length);
    }

    AbstractTreeIterator min() throws CorruptObjectException {
        int i = 0;
        AbstractTreeIterator minRef = this.trees[i];
        while (minRef.eof() && ++i < this.trees.length) {
            minRef = this.trees[i];
        }
        if (minRef.eof()) {
            return minRef;
        }
        minRef.matches = minRef;
        while (++i < this.trees.length) {
            AbstractTreeIterator t = this.trees[i];
            if (t.eof()) continue;
            int cmp = t.pathCompare(minRef);
            if (cmp < 0) {
                t.matches = t;
                minRef = t;
                continue;
            }
            if (cmp != 0) continue;
            t.matches = minRef;
        }
        return minRef;
    }

    void popEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        int i = 0;
        while (i < this.trees.length) {
            AbstractTreeIterator t = this.trees[i];
            if (t.matches == ch) {
                t.next(1);
                t.matches = null;
            }
            ++i;
        }
    }

    void skipEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        int i = 0;
        while (i < this.trees.length) {
            AbstractTreeIterator t = this.trees[i];
            if (t.matches == ch) {
                t.skip();
                t.matches = null;
            }
            ++i;
        }
    }

    private void exitSubtree() {
        --this.depth;
        int i = 0;
        while (i < this.trees.length) {
            this.trees[i] = this.trees[i].parent;
            ++i;
        }
        AbstractTreeIterator minRef = null;
        AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTreeIterator t = abstractTreeIteratorArray[n2];
            if (t.matches == t && (minRef == null || t.pathCompare(minRef) < 0)) {
                minRef = t;
            }
            ++n2;
        }
        this.currentHead = minRef;
    }

    private CanonicalTreeParser parserFor(AnyObjectId id) throws IncorrectObjectTypeException, IOException {
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(this.reader, id);
        return p;
    }

    static String pathOf(AbstractTreeIterator t) {
        return RawParseUtils.decode(Constants.CHARSET, t.path, 0, t.pathLen);
    }

    static String pathOf(byte[] buf, int pos, int end) {
        return RawParseUtils.decode(Constants.CHARSET, buf, pos, end);
    }
}

