/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;

public class ChangeIdUtil {
    private static final Pattern issuePattern = Pattern.compile("^(Bug|Issue)[a-zA-Z0-9-]*:.*$");
    private static final Pattern footerPattern = Pattern.compile("(^[a-zA-Z0-9-]+:(?!//).*$)");
    private static final Pattern includeInFooterPattern = Pattern.compile("^[ \\[].*$");

    static String clean(String msg) {
        return msg.replaceAll("(?i)(?m)^Signed-off-by:.*$\n?", "").replaceAll("(?m)^#.*$\n?", "").replaceAll("(?m)\n\n\n+", "\\\n").replaceAll("\\n*$", "").replaceAll("(?s)\ndiff --git.*", "").trim();
    }

    public static ObjectId computeChangeId(ObjectId treeId, ObjectId firstParentId, PersonIdent author, PersonIdent committer, String message) throws IOException {
        String cleanMessage = ChangeIdUtil.clean(message);
        if (cleanMessage.length() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append("tree ");
        b.append(ObjectId.toString(treeId));
        b.append("\n");
        if (firstParentId != null) {
            b.append("parent ");
            b.append(ObjectId.toString(firstParentId));
            b.append("\n");
        }
        b.append("author ");
        b.append(author.toExternalString());
        b.append("\n");
        b.append("committer ");
        b.append(committer.toExternalString());
        b.append("\n\n");
        b.append(cleanMessage);
        return new ObjectInserter.Formatter().idFor(1, b.toString().getBytes("UTF-8"));
    }

    public static String insertId(String message, ObjectId changeId) {
        if (message.indexOf("\nChange-Id:") > 0) {
            return message;
        }
        String[] lines = message.split("\n");
        int footerFirstLine = lines.length;
        int i = lines.length - 1;
        while (i > 1) {
            if (footerPattern.matcher(lines[i]).matches()) {
                footerFirstLine = i;
            } else {
                if (footerFirstLine != lines.length && lines[i].length() == 0) break;
                if (footerFirstLine != lines.length && includeInFooterPattern.matcher(lines[i]).matches()) {
                    footerFirstLine = i + 1;
                } else {
                    footerFirstLine = lines.length;
                    break;
                }
            }
            --i;
        }
        int insertAfter = footerFirstLine;
        int i2 = footerFirstLine;
        while (i2 < lines.length) {
            if (!issuePattern.matcher(lines[i2]).matches()) break;
            insertAfter = i2 + 1;
            ++i2;
        }
        StringBuilder ret = new StringBuilder();
        int i3 = 0;
        while (i3 < insertAfter) {
            ret.append(lines[i3]);
            ret.append("\n");
            ++i3;
        }
        if (insertAfter == lines.length && insertAfter == footerFirstLine) {
            ret.append("\n");
        }
        ret.append("Change-Id: I");
        ret.append(ObjectId.toString(changeId));
        ret.append("\n");
        while (i3 < lines.length) {
            ret.append(lines[i3]);
            ret.append("\n");
            ++i3;
        }
        return ret.toString();
    }
}

