FILE_NAME = 'archive/scrubbed.csv'

def read_file(filename, state_counts, country_counts, durations):
    """
    This functions reads the file with UFO data and populates a dictionary
    """
    with open(filename) as f:
        next(f)
        for line in f:
            line = line.strip()
            info = line.split(",")
            state = info[2]
            country = info[3]
            duration = info[5]

            #append to the list of durations
            if duration.isdigit():
                durations.append(int(duration))

            #increase the count for a given state
            if state not in state_counts:
                state_counts[state] = 0
            state_counts[state] += 1

            #increase the count for a given country
            if country not in country_counts:
                country_counts[country] = 0
            country_counts[country] += 1


def max_place(counts):
    """
    This function returns the key associated with the highest count in the
    counts dictionary.
    """
    max = 0
    max_place = ''
    for (place, count) in counts.items():
        if count > max:
            max = count
            max_place = place
    return max_place

def main():
    #read file and store information
    state_counts = {}
    country_counts = {}
    durations = []
    read_file(FILE_NAME, state_counts, country_counts, durations)

    #get some statistics


if __name__ == "__main__":
    main()