#!/usr/bin/env python3

"""
Stanford CS106AP Warmups
Warmup problems developed by
Sonja Johnson-Yu, Kylie Jue, and Nick Bowman.
"""

def print_vote_counts(votes):
	"""
	This function tallies the counts of votes cast in an 
	election and prints out the resulting number of 
	votes that a candidate received. 

	Input:
		votes (List[str]): A list of candidate names

	Output: 
		This function prints out the number of votes received
		by each candidate. The tally should be printed out
		in alphabetical order of the first letter of candidate names.

	>>> print_vote_counts(['Nick'])
	Nick 1
	>>> print_vote_counts(['Nick', 'Sonja', 'Nick', 'Nick', 'Kylie'])
	Kylie 1
	Nick 3
	Sonja 1
	>>> print_vote_counts(['Zaphod Beeblebrox','Arthur Dent', 'Trillian McMillian', 'Zaphod Beeblebrox', 'Marvin', 'Mr. Zarniwoop', 'Trillian McMillian', 'Zaphod Beeblebrox'])
	Arthur Dent 1
	Marvin 1
	Mr. Zarniwoop 1
	Trillian McMillian 2
	Zaphod Beeblebrox 3
	"""
	pass


def group_by_first_letter(words):
	"""
	Given a list of non-empty words, build a "dictionary" dict that
	groups words together by the first letter. This function should
	be case-insensitive.

	Input:
		words (List[str]): A list of words

	Returns:
		dictionary (dict[str:List[str]]) A dict that maps letters
		to all words that start with that letter.

	>>> group_by_first_letter(['Alphabet', 'soup'])
	{'a': ['Alphabet'], 's': ['soup']}
	>>> group_by_first_letter(['Nick', 'Kylie', 'Sonja', 'kite', 'snek'])
	{'n': ['Nick'], 'k': ['Kylie', 'kite'], 's': ['Sonja', 'snek']}
	"""
	pass
