#!/usr/bin/env python3

"""
Stanford CS106AP
TK Drawing Lecture Exercises
Courtesy of Nick Parlante
"""

import sys
import tkinter
import random


# provided function, this code is complete
def make_canvas(width, height):
    """
    Creates and returns a drawing canvas
    of the given int size with a blue border,
    ready for drawing.
    """
    top = tkinter.Tk()
    top.minsize(width=width + 10, height=height + 10)

    canvas = tkinter.Canvas(top, width=width, height=height)
    canvas.pack()
    canvas.xview_scroll(6, "units")  # hack so (0, 0) works correctly
    canvas.yview_scroll(6, "units")

    # draw blue boundaries - sides
    canvas.create_line(0, 0, 0, height-1, width=1, fill='blue')
    canvas.create_line(width-1, 0, width-1, height-1, width=1, fill='blue')
    # top bottom
    canvas.create_line(0, 0, width - 1, 0, width=1, fill='blue')
    canvas.create_line(0, height - 1, width - 1, height - 1, width=1, fill='blue')

    return canvas


# Some of the TK color names
COLORS = ['red', 'orange', 'yellow', 'green', 'blue', 'purple',
          'cyan', 'dark green', 'pink', 'black']


def draw_pyramid(n, width, height):
    """
    Draw N lines starting evenly spaced from x=0 to x=width-1
    along the bottom edge, all going up to a point at the middle
    of the top edge. This makes a pyramid shape. N will be 2 or more.
    """
    canvas = make_canvas(width, height)

    # your code
    pass


def draw_nest(delta, width, height):
    """
    Given int width, height, and delta,
    draw nested ovals. First draw the maximum possible oval
    within the canvas.
    Draw a smaller oval with each of the 4 sides moved in by delta.
    Continuing until the oval is zero size.
    Use canvas.create_oval(x, y, x2, y2)
    x/y and x2/y2 are corners that define a rectangle
    the oval touches.
    """
    canvas = make_canvas(width, height)

    # your code
    pass


# (provided)
def main():
    args = sys.argv[1:]
    # Arg forms:
    # -pyramid n
    # -nest n

    # Figure window size (default 500 x 300)
    # Optionally command line can have width height numbers to override
    # e.g. -pyramid 10 1000 500
    width = 500
    height = 300
    if len(args) == 4:
        width = int(args[2])
        height = int(args[3])

    if len(args) >= 2 and args[0] == '-pyramid':
        draw_pyramid(int(args[1]), width, height)
        tkinter.mainloop()

    if len(args) >= 2 and args[0] == '-nest':
        draw_nest(int(args[1]), width, height)
        tkinter.mainloop()


if __name__ == '__main__':
    main()
