class PyPalAccount:
    def __init__(self, name, amount):
        self.name = name
        self.amount = amount

    def deposit(self, deposit_amount):
        """
        Allows the user to deposit a positive amount of money
        into their account. Returns whether or not the 
        deposit was successful.
        """
        if deposit_amount < 0:
            print("Sorry, you can't deposit negative money!")
            return False
        self.amount += deposit_amount
        return True

    def withdraw(self, withdrawal_amount):
        """
        Allows the user to withdraw some amount of money
        from their account. Returns whether or not the 
        withdrawal was successful.
        """
        if withdrawal_amount < 0:
            print("Sorry, you can't withdraw negative money!")
            return False
        elif withdrawal_amount > self.amount:
            print("Sorry, you don't have enough money in your account to do that!")
            return False
        else:
            self.amount -= withdrawal_amount
            return True

    def transfer(self, recipient, transfer_amount):
        """
        Allows the user to transfer a certain amount of money to 
        a recipient, represented as another PyPalAccount object. Returns
        whether or not the transfer was successful.
        """
        success = self.withdraw(transfer_amount)
        if success:
            return recipient.deposit(transfer_amount)
        else:
            print("Wasn't able to make the necessary withdrawal, terminating transfer")
            return False

    def get_amount(self):
        return self.amount

    def get_name(self):
        return self.name


def main():
    nick = PyPalAccount("Nick", 100)
    sonja = PyPalAccount("Sonja", 1000)

    # Nick gets his paycheck and deposits it
    nick.deposit(500)

    # Sonja wants to buy a new enclosure for her chickens
    sonja.withdraw(900)

    # Nick wants to travel to Costa Rica to hang out with sloths
    nick.withdraw(2000)
    # Oops, not enough money! But account status is still valid
    print(nick.get_amount())

    # Nick wants to transfer some money to Sonja for lunch
    nick.transfer(sonja, 20)

    print(nick.get_name(), nick.get_amount())
    print(sonja.get_name(), sonja.get_amount())


if __name__ == '__main__':
    main()
